#!/usr/bin/python
# -*- coding: utf-8 -*-
import time
import traceback
import uuid

from getDBConnection import get_zenith_session
from common_tasks.base_task import BaseTask

ONE_PACKAGE = 500


class UpgradeSshFingerprintConfig(BaseTask):
    def __init__(self, product_name="NCE"):
        super(UpgradeSshFingerprintConfig, self).__init__()
        self.set_product_name(product_name)
        self.info("UpgradeSshFingerprintConfig init product_name is %s" % product_name)
        self.src_db_session = get_zenith_session('MCDB', 'MCDB', product_name)
        if self.src_db_session is None:
            self.error("MCDB is None")
            return
        self.src_db_session.autocommit(True)
        self.src_db_cursor = self.src_db_session.cursor()

        self.dst_db_session = get_zenith_session('neresdb', 'neresdb', product_name)
        if self.dst_db_session is None:
            self.error("neresdb is None")
            return
        self.dst_db_session.autocommit(True)
        self.dst_db_cursor = self.dst_db_session.cursor()

        self.src_table = "tbl_usercfg_param"
        self.src_table_cols = ("strSubSystemName", "strItemName", "strItemValue", "strDefaultValue",
                               "strDescription", "strReStartupProcessList", "intUpgradePolicy", "intEditType",
                               "strFileName")
        self.src_table_cols_index = {y:x for x, y in enumerate(self.src_table_cols)}
        self.dst_table = "SshFingerprintConfig"
        self.dst_table_cols = ("modelId", "fModelId", "tenantId",
                               "trustFirstFingerprint", "trustModifiedFingerprint",
                               "createAt", "updateAt")

    def convert_data(self, paras):
        modelId = str(uuid.uuid1())
        fModelId = None
        tenantId = "default-organization-id"

        trustFingerprintMap = {
            "0": True,
            "1": False
        }
        trustFirstFingerprint = trustFingerprintMap.get(str(paras[self.src_table_cols_index.get("strItemValue")]))
        trustModifiedFingerprint = trustFingerprintMap.get(str(paras[self.src_table_cols_index.get("strItemValue")]))

        createAt = str(int(time.time() * 1000))
        updateAt = str(int(time.time() * 1000))

        return tuple(None if x is None else str(x) for x in (modelId, fModelId, tenantId, trustFirstFingerprint,
                                                             trustModifiedFingerprint, createAt, updateAt))

    def to_UpgradePara(self, datas):
        col_names = "`" + ("`, `".join(self.dst_table_cols)) + "`"
        val_ids = ":" + (",:".join((str(x+1) for x in range(len(self.dst_table_cols)))))
        insert_stmt = "INSERT INTO `%s` (%s) VALUES(%s)" % (self.dst_table, col_names, val_ids)
        self.debug("insert sql stmt: %s" % insert_stmt)
        list_datas = []
        for data in datas:
            self.debug("original data is: %s, length is:%s" % (data, len(data)))
            data = self.convert_data(data)
            self.debug("coverted date is: %s, length is:%s"%(data, len(data)))
            if len(data) == len(self.dst_table_cols):
                tuple_data = tuple(data)
                list_datas.append(tuple_data)
            if len(list_datas) == ONE_PACKAGE:
                self.exec_sql(insert_stmt, list_datas)
                list_datas = []

        if len(list_datas) != 0:
            self.exec_sql(insert_stmt, list_datas)

    def close_session(self):
        self.dst_db_cursor.close()
        self.dst_db_session.close()
        self.src_db_cursor.close()
        self.src_db_session.close()

    def do(self):
        try:
            self.info('UpgradeSshFingerprintConfig::do start!')
            select_stmt = "select %s from %s where strItemName='OPERATION_MODE'" % (",".join(self.src_table_cols), self.src_table)
            datas = self.exec_query_sql(self.src_db_cursor, select_stmt)
            self.info('get para data success count:%d'%len(datas))

            self.to_UpgradePara(datas)
            self.info('to_UpgradePara done')
            self.close_session()
        except Exception as e:
            self.close_session()
            self.error('UpgradeSshFingerprintConfig got exception')
            self.error(traceback.format_exc())
            return -1
        self.info('UpgradeSshFingerprintConfig::do done')
        return 0


if __name__ == '__main__':

    tool = UpgradeSshFingerprintConfig()
    print('[INFO] UpgradeSshFingerprintConfig start>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
    tool.do()
    print('[INFO] UpgradeSshFingerprintConfig finished<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
