#!/bin/bash

SCRIPT_NAME=`basename $0`
LOG_FILE="/tmp/${SCRIPT_NAME}.log"

# 日志记录
function log()
{
    local msg=$1
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" |tee -a $LOG_FILE
}

# 校验入参
function check_input()
{
    if [ "${1}" == "-input" -a -n "${2}" ]
    then
        INPUT_PATH=${2}
    else
        log "ERROR The input param is invalid."
        exit 0
    fi
}

# 检查版本
function check_version()
{
    src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
    is_R21C00=`echo ${src_version} | grep V100R021C00`
    is_R21C10=`echo ${src_version} | grep V100R021C10`
    if [ -z "${is_R21C00}" ] && [ -z "${is_R21C10}" ]; then
        return 1
    fi
    log "src_version:[${src_version}] need disable cloudlicenseproxy"
    return 0
}

# 在某个节点禁用某个服务
function disable_service()
{
    local target_ip=$1
    log "Start to disable CloudLicenseProxy on ${target_ip}"
    bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -tenant ${PRODUCTNAME} -app CloudLicenseProxy" -u ossadm -timeout 3600 -encrypt N | tee -a ${LOG_FILE} 2>&1
    if [ $? -ne 0 ]
    then
        log "Node ${target_ip}:Failed to stopapp CloudLicenseProxy."
        return 1
    fi
    bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd disable -app CloudLicenseProxy" -u ossadm -timeout 3600 -encrypt N | tee -a ${LOG_FILE} 2>&1
    if [ $? -ne 0 ]
    then
        log "Node ${target_ip}:Failed to disable CloudLicenseProxy."
        return 1
    fi
    log "Finished to disable CloudLicenseProxy on ${target_ip}"
}

# 在所有节点禁用某个服务
function disable_all_node_server()
{
    PRODUCTNAME=`cat ${INPUT_PATH}/plandata.json | grep productname | tr '"' ' ' | awk '{print $3 }'`
    SSHTOOL="${OSS_ROOT}/tools/common/sshmgr/sshmgr.sh"
    local nodeips=$(bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -tenant ${PRODUCTNAME} -app CloudLicenseProxy -nodeip global | grep "CloudLicenseProxy" | awk -F " " '{print $6}')
    for nodeip in ${nodeips}
    do
        disable_service "${nodeip}"
        if [ $? -ne 0 ]
        then
            log "Failed to disable CloudLicenseProxy."
            return 1
        fi
    done
}

# 检查入参
check_input "$@"
check_version
verMatch=$?
log "src_version match=${verMatch}"

. /opt/oss/manager/bin/engr_profile.sh
if [ ${verMatch} == 0 ]
then
    disable_all_node_server
fi

# 脚本执行完正常退出，不影响整个升级流程
exit 0