# coding: utf-8
"""
功 能：仲裁节点检查
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2022-5-18 12:00 创建
"""
import logging
import os
import time
from utils.sshUtil import CsshCmd
from utils.log_util import EasysuiteLogger
from easysuite import settings
from func.upgrade.upgrade_operation_mgr.common.upgrade_util import UpgradeUtil

LOCAL_LOGGER = logging.getLogger(__name__)


def execute_task_check(kvs):
    """
    检查仲裁节点
    """
    logger = EasysuiteLogger.get_logger(kvs, "task_check_arbitration_node_sopuser_and_opt")
    logger.easysuite_start("begin to check")
    check_result = True

    # 判断是否升级勾选OS升级，只有升级OS的情况下才需要对opt空间做检查
    if "id_upgrade_os" in kvs.get("upgrade_item"):
        if not exec_check(kvs, shell_check_opt_space_cmd(), logger):
            check_result = False

    if not exec_check(kvs, shell_check_sopuser_passwd_cmd(), logger):
        check_result = False

    if check_result:
        logger.easysuite_finish("check success")
    else:
        logger.easysuite_error("check failed")
    return check_result


def get_arbit_param(kvs):
    arbit_node = {
        'login_user': kvs.get("node_arbitrate_login_user"),
        'login_pwd': kvs.get("node_arbitrate_login_pwd"),
        'ssh_port': kvs.get("node_arbitrate_ssh_port"),
        'login_ip': UpgradeUtil.get_value_from_main(kvs.get("easysuite.task_id"), "arbitrate_ip"),
        'sftp_port': kvs.get("node_arbitrate_sftp_port"),
        'su_pwd': kvs.get('node_arbitrate_root_pwd')
    }
    return arbit_node


def exec_check(kvs, cmd, logger):
    LOCAL_LOGGER.info("start exec_check")
    final_cmd = f'''{shell_log_cmd()};{cmd}'''
    LOCAL_LOGGER.info(f"final_cmd={final_cmd}")

    arbit_node = get_arbit_param(kvs)

    check_result, check_output = CsshCmd.exec_shell_cmd_su_root(arbit_node.get("login_ip"),
                                                                arbit_node.get("login_user"),
                                                                arbit_node.get("login_pwd"), final_cmd,
                                                                arbit_node.get("su_pwd"))

    LOCAL_LOGGER.info(f"check_result={check_output}")
    LOCAL_LOGGER.info(f"check_output={check_output}")
    if not check_result or "ERROR" in check_output:
        logger.easysuite_error("check result:" + check_output)
        return False
    else:
        logger.easysuite_info("check result:" + check_output)
    return True


def shell_log_cmd():
    return '''function log() {
log_type=$1
mes=$2
echo "$(date '+%Y-%m-%d %H:%M:%S') $log_type $mes"
}'''


def shell_check_opt_space_cmd():
    return '''function check_opt_space() { 
cat /proc/version | grep euleros &>> /dev/null
if [ $? -ne 0 ];then
    log "INFO" "Non-EulerOS, the opt space does not need to be checked."
    return 0
fi
# 跨R版本升级才检查opt空间
uname -r | grep -i eulerosv2r10 &>> /dev/null
if [ $? -eq 0 ];then
    log "INFO" "Upgrade OS within the B version, do not need to check the /opt space."
    return 0
fi
local opt_avail_space=""
lsblk | grep '/opt' &>> /dev/null
if [ $? -eq 0 ]; then
    opt_avail_space=$(df -m /opt/ | tail -1 | awk -F ' ' '{print $4}')
else
    opt_avail_space=$(df -m /| tail -1 | awk -F ' ' '{print $4}')
fi

# /opt空间小于4G，升级OS必定失败，报问题，保险起见，阈值设置为6G
# shell存在小数比较
if [ $(echo "${opt_avail_space} < 6*1024"|bc) -eq 1 ];then
    log "ERROR" "The arbitration node /opt space is ${opt_avail_space}M, which is less than 6*1024 M. The OS upgrade will failed."
    return 1
else
    log "INFO" "/opt space is ok, opt_avail_space=${opt_avail_space}M"
fi
}; check_opt_space'''


def shell_check_sopuser_passwd_cmd():
    return '''check_sopuser_valid() {
id sopuser &>> /dev/null
if [ $? -ne 0 ];then
    log "INFO" "The sopuser user does not exist, do not need to check sopuser valid"
    return 0
fi
local expire_time=$(chage -l 'sopuser' 2>/dev/null | grep 'Password expires' | awk -F: '{print $2}')
if echo "${expire}" | grep "never" &>> /dev/null
then
    log "INFO" "check sopuser valid is ok"
    return 0
fi
local expire_num=$(date -d "${expire_time}" +%s)

local offset_day=$(date -I -d '+7 day')
local offset_num=$(date -d "${offset_day}" +%s)

if [ "${offset_num}" -gt "${expire_num}" ];then
    log "ERROR" "sopuser password will expire in less than 7 days" 
    log "INFO" "Please change the password of the sopuser user."
else
    log "INFO" "Check the validity period of the sopuser user is ok." 
fi
}; check_sopuser_valid'''



def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: 检查结果
    """
    # 只有升级勾选了仲裁节点才做检查
    return kvs.get("is_arbitration_exist") == "yes" and "id_upgrade_arbitration" in kvs.get("upgrade_item")


def exe(kvs):
    return [[('', '', execute_task_check(kvs))]]
