#!/bin/bash
##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
BASH_PID=$$

##################################################
# 接收参数
##################################################
SELECT_1="$1"
SELECT_2="$3"
TASK_ID="$2"
EXEC_PARAM="$4"

##################################################
# 初始化任务路径
##################################################
TASK_ID_PATH="/opt/upgrade/easysuite_upgrade/taskmgr/${TASK_ID}"

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/upgrade/easysuite_upgrade/logs"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 校验入参
# @param
#   taskid   --c6bfc6d0a769c2b319f9
#   param   --c6bfc6d0a769c2b319f9
##################################################
function check_input()
{
    local input_vaild="TRUE"
    if [ -z "${SELECT_1}" -o -z "${SELECT_2}" -o -z "${TASK_ID}" -o -z "${EXEC_PARAM}" ]
    then
        local input_vaild="FALSE"
    fi
    if [ "${SELECT_1}" != "-taskid" -o "${SELECT_2}" != "-param" ]
    then
        local input_vaild="FALSE"
    fi
    if [ "${input_vaild}" == "FALSE" ]
    then
        LOG "ERROR" "bash ${SELF_FILE}.sh -taskid c6bfc6d0a769c2b319f9 -param **:**"
        LOG "ERROR" "The input param is invalid."
        return 0
    fi
}

##################################################
# 记录日志并刷新进度信息
##################################################
function print_log()
{
    local progress=$1
    local status=$2
    local msg=$3

    local task_log=${TASK_ID_PATH}/task.log
    local task_status=${TASK_ID_PATH}/task.status
    local task_progress=${TASK_ID_PATH}/task.progress

    [ -n "${msg}" ] && echo "[$(date +'%Y-%m-%d %H:%M:%S')] [${BASH_PID}] | ${msg}" >>${task_log}
    [ "${status}" == "fail" -o "${status}" == "finish" ] && echo "Status=${status}" >${task_status}
    [ -n "${progress}" ] && echo "Progress=${progress}" >${task_progress}
}

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        print_log "100" "finish" "INFO: upload fail. User(${user}) have no permission to run this script."
        return 0
    fi
}

# 添加license文件
function add_new_license()
{
    if [ "${EXEC_PARAM}" == "None" ]
    then
        print_log "100" "finish" "INFO: upload fail. The new license file not found!."
        return 0
    fi

    if [ -f "${SCRIPT_PATH}/pyscripts/add_new_license.pyc" ]
    then
        local add_new_license="${SCRIPT_PATH}/pyscripts/add_new_license.pyc"
    elif [ -f "${SCRIPT_PATH}/pyscripts/add_new_license.py" ]
    then
        local add_new_license="${SCRIPT_PATH}/pyscripts/add_new_license.py"
    else
        print_log "100" "finish" "INFO: upload fail. Can not find add_new_license.py file."
        return 0
    fi

    source /opt/oss/manager/bin/engr_profile.sh
    export SSL_ROOT=/opt/oss/manager/etc/ssl
    export CIPHER_ROOT=/opt/oss/manager/etc/cipher
    python ${add_new_license} "${EXEC_PARAM}" >>${LOG_FILE}
    local result=$?
    # 除0外，其余返回状态均为上传异常
    if [ ${result} -eq 0 ]
    then
        print_log "100" "finish" "INFO: The new license is added successfully."
        return 0
    elif [ ${result} -eq 1 ]
    then
        print_log "100" "finish" "INFO: upload fail. license file not found, Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 2 ]
    then
        print_log "100" "finish" "INFO: upload fail. license file Format Exception, Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 3 ]
    then
        print_log "100" "finish" "INFO: upload fail. Failed to obtain the token, Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 4 ]
    then
        print_log "100" "finish" "INFO: upload fail. Code: 400 For detail, see /opt/oss/log/manager/easysuite_upgrade/add_new_license.py.log. Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 6 ]
    then
        print_log "100" "finish" "INFO: upload fail. Code: 406 Parameter Error. For detail, see /opt/oss/log/manager/easysuite_upgrade/add_new_license.py.log. Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 5 ]
    then
        print_log "100" "finish" "INFO: upload fail. Code: 500 Inner Service Error. For detail, see /opt/oss/log/manager/easysuite_upgrade/add_new_license.py.log. Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 7 ]
    then
        print_log "100" "finish" "INFO: upload fail. try_count > product_node_len. Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 8 ]
    then
        print_log "100" "finish" "INFO: upload fail. licenseObjectStr is None. Please go to the O&M Plane to manually import the license file"
        return 0
    elif [ ${result} -eq 9 ]
    then
        print_log "100" "finish" "INFO: upload fail. result is not tuple. Please go to the O&M Plane to manually import the license file"
        return 0
    fi
    print_log "100" "finish" "INFO: upload fail. Please go to the O&M Plane to manually import the license file"
    return 0
}

function main()
{
    check_input || return 1

    . ${SCRIPT_PATH}/common.sh
    LOG "INFO" "Start to init ${LOG_FILE}."

    init_taskmgr ${TASK_ID}

    check_user || return 1

    add_new_license
    return $?
}

main
exit $?