#!/bin/bash
##################################################
# 删除升级过程上传的包和临时文件
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
[ ! -e "${LOG_PATH}" ] && mkdir -p "${LOG_PATH}"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

# 日志记录进/opt/oss/log/manager/easysuite_upgrade/scriptlog/${SELF_FILE}.log
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    if [ "$(whoami)" = "root" ]
    then
      su - ossadm -c "echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}"
    else
      echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
    fi
}

# 设置清理参数
function set_clear_params() {
    # 清理目录
    CLEAN_DIR=$1

    # 为空不处理
    if [ -z "${CLEAN_DIR}" ]
    then
        LOG "WARN" "The input dir is null."
        exit 0
    fi

    # 传进来的路径为"/"不处理
    if [ "${CLEAN_DIR}" == "/" ]
    then
        LOG "WARN" "The input dir \"${CLEAN_DIR}\" is invalid."
        exit 0
    fi

    # 除去末尾/
    CLEAN_DIR=$(echo ${CLEAN_DIR} | sed 's/\/$//')

    # 默认清理目录
    DEFALUT_PATH="/opt/upgrade"

    # 清理白名单,需要考虑配置规则前后版本集成以及统一配置接口
    WHITE_LIST=(iMaster.*_BKSigntool_linux.* iMaster.*OSPatchtool.*.zip iMaster.*EulerOS.*Patch.*.zip iMasterNCEServerInstall.*Patch.*.tar iMaster.*_OSMediation_.* iMaster.*AAMonitor.*.zip)
}

# 清理非默认路径软件包
function custom_clean()
{
    local dir_path=$1
    LOG "INFO" "Start to clear directory ${dir_path}."
    if [ -d "${dir_path}" ]
    then
        rm -f ${dir_path}/*.verify_result
        cmd_files=$(find ${dir_path} -name "*.cms" -o -name "*.p7s" | xargs -i echo \'{}\')
        [ -z "${cmd_files}" ] && return 0
        cmd="ls $cmd_files 2>/dev/null"
        for list in ${WHITE_LIST[@]}
        do
            cmd="${cmd} | grep -v ${list}"
        done
        local file_names=$(eval ${cmd} | awk -F '.cms|.p7s' '{print $1}')
        for file in ${file_names}
        do
            if [ ! -d "${file}" ]
            then
                LOG "INFO" "Start to delete files ${file}*."
                rm -f "${file}"*
                LOG "INFO" "Finished to delete files ${file}*."
            fi
        done
    fi
    LOG "INFO" "Finished to clear directory ${dir_path}."
}

# 清理默认软件包及自定义目录软件包
# /opt/upgrade目录下的自定义目录存在白名单文件时，也会正常保留
function clean_packages()
{
    local es_backup="${DEFALUT_PATH}/backup"
    local es_upgrade="${DEFALUT_PATH}/easysuite_upgrade"
    local cmd='find ${DEFALUT_PATH}/* | grep -v "${es_upgrade}" | grep -v "${es_backup}"'

    if [ -d "${DEFALUT_PATH}" ]
    then
        rm -f ${DEFALUT_PATH}/*.verify_result
        # 去除包含白名单文件的文件夹及白名单文件
        for list in ${WHITE_LIST[@]}
        do
            cmd="${cmd} | grep -v ${list}"
            tmp_dir=$(find ${DEFALUT_PATH}/* | grep ${list} | xargs dirname 2>/dev/null | sort -u)
            tmp_exc_dir=$(echo ${tmp_exc_dir} ${tmp_dir})
        done
        for dir in ${tmp_exc_dir}
        do
            if [ "${dir}" != "${DEFALUT_PATH}" -a "${dir}" != "${CLEAN_DIR}" ]
            then
                exc_dir="${exc_dir} ${dir}"
            fi
        done
        for dir in ${exc_dir}
        do
            cmd="${cmd} | grep -v ${dir}"
        done
        # 清理自定义路径
        if [ "${CLEAN_DIR}" != "${DEFALUT_PATH}" ]
        then
            custom_clean ${CLEAN_DIR}
            cmd="${cmd} | grep -v "'"${CLEAN_DIR}"'
        fi
        cmd="${cmd} | xargs rm -rf"
        eval ${cmd}
        # 清理存在白名单文件的文件夹
        for dir in ${exc_dir}
        do
            custom_clean ${dir}
        done
    else
        return 0
    fi

    if [ -d "${es_upgrade}" ]
    then
        find ${es_upgrade}/* 2>/dev/null | grep -v "${es_upgrade}/workpath" | xargs rm -rf
    else
        return 0
    fi

    if [ -d "${es_upgrade}/workpath" ]
    then
        find "${es_upgrade}/workpath" -type f | grep -v "/plandata/" | grep -v "/pre_upgrade/" | xargs rm -f
    else
        return 0
    fi
    return 0
}

function main()
{
    set_clear_params $1

    clean_packages
}

main "$@"
exit $?