#!/bin/bash
##################################################
# 功能说明:获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 功能说明:初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 功能说明:加载公共脚本
##################################################
source ${SCRIPT_PATH}/../common.sh

##################################
# 功能说明:脚本总入口
##################################
function main()
{
    # 校验脚本执行用户
    check_user || return 1

    PYTHON_SCRIPT="${SCRIPT_PATH}/pyscripts/switch_dr_float_ip.py"

    execute_python_script "$@"
}

main "$@" &
exit $?
