#!/bin/bash

# ű·
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# ű
SELF_FILE=$(basename $0)

# ű־·
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog/"

#ű־ļ
LOG_FILE="${LOG_PATH}/${SELF_FILE}.log"

# ùĿ¼
WORK_PATH="/opt/upgrade/easysuite_upgrade/workpath/"

# Ʒ plandata.json productnam
PRODUCT_NAME=""

# · plandata.json src_version-des_version
UPGRADE_PATH=""

# WORK_PATH/UPGRADE_PATH/workpath-PRODUCT_NAME/
CONFIG_PATH=""

# INPUTļ·  plandata.json
INPUT_FILE="${2}/plandata.json"

# űʱ·
CONFIG_DIR="/opt/oss/log/manager/easysuite_upgrade_config"
[ ! -e "${CONFIG_DIR}" ] && mkdir -p "${CONFIG_DIR}"
TMP_PATH="${CONFIG_DIR}/fresh_monitor_full_ability_$(date '+%s')"

# ؼֵֶ
MONITOR_FULL_ABILITY=""

##########################################
#  ޸ monitor_full_ability ֶ
##########################################
function modify_monitor_full_ability()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    file_data = json.load(r_stream)
with open('${file_path}', 'w', encoding='utf-8') as w_stream:
    if file_data.get('productext', {}).get('monitor_full_ability'):
        file_data.get('productext', {}).update({'monitor_full_ability': '0'})
    json.dump(file_data, w_stream)
END
    return 0
}

##########################################
#  ǰ monitor_full_ability ֶ
##########################################
function check_pre_upgrade_config()
{
    CONFIG_PATH="${WORK_PATH}/${UPGRADE_PATH}/workpath-${PRODUCT_NAME}/pre_upgrade"
    config_file="${CONFIG_PATH}/pre_upgrade_config.properties"
    if [ ! -f "${config_file}" ]
    then
        # ļ˳
        return 0
    fi

    # Ŀ¼ڼļ
    grep_msg=$(grep "^monitor_full_ability=1" "${config_file}" 2>/dev/null)
    if [ $? -ne 0 ]
    then
        return 0
    fi

    MONITOR_FULL_ABILITY="1"
    LOG_PRINT "INFO" "Pre-upgrade configuration(key:monitor_full_ability): ${grep_msg}"
    return 1
}

##########################################
#  ָ monitor_full_ability ؼֶ
##########################################
function restore_monitor_full_ability()
{
    # ʱĿ¼
    mkdir -p ${TMP_PATH}

    # ǰؼֶ,޹ؼֶ˳
    check_pre_upgrade_config || return 0

    # ѯ product_NCE.json
    query_product "${TMP_PATH}" "${PRODUCT_NAME}" || return 1

    # ޸ product_NCE.json
    modify_monitor_full_ability "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1

    #  product_NCE.json
    modify_product "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1

    # ˳ʱĿ¼
    rm -rf ${TMP_PATH}
}

##########################################
#  
##########################################
function main()
{
    # عģ
    source $(dirname ${SCRIPT_PATH})/common.sh

    # ִû
    check_ossadm_user || return 1

    # ʼ
    initial_params "${INPUT_FILE}" || return 1

    # ƽ̨
    source /opt/oss/manager/bin/engr_profile.sh

    # ¹ؼֶ
    restore_monitor_full_ability || return 1

    # Ĭ˳ 0
    return 0
}

main "$@"
exit $?