#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"


##################################################
# 校验执行用户
# 脚本要求使用oss用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    oss_user=$(id -nu 3001)
    if [ "${user}" != "${oss_user}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script"
        return 1
    fi
}

##################################################
# 日志记录进/tmp/${SELF_FILE}.log
##################################################
function LOG()
{
    BASH_PID=$$
    if [ "$1" = "ERROR" -o "$1" = "error" ]
    then
        Level="ERROR"
    elif [ "$1" = "WARN" -o "$1" = "warn" ]
    then
        Level="WARN"
    else
        Level="INFO"
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${BASH_PID}] | ${Level} $2" | tee -a ${LOG_FILE}
}

# 入参校验
function check_param()
{
    local check_tmp=$1
    [ -z "${check_tmp}" ] && return 1
    echo "${check_tmp}" | fgrep -q "../"
    if [ $? -eq 0 ]
    then
        LOG "ERROR" "The input param \"${check_tmp}\" is invalid."
        return 1
    fi
    if [ ! -d "${check_tmp}" ]
    then
        LOG "ERROR" "The input param \"${check_tmp}\" is invalid."
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    local num=$#
    if [ $((${num}%2)) -eq 1 ]
    then
        num=$((${num}/2+1))
    else
        num=$((${num}/2))
    fi
    local count=1
    for((i=1;i<=${num};i++))
    do
        [[ ${1#-} == "input" ]] && { INPUTPATH=$2;shift 2;check_param "${INPUTPATH}" || return 1; continue; }
    done
}

function check_input()
{
    init_params "$@"
    if [ $? -ne 0 ]
    then
        echo "Example: bash ${SELF_FILE} -input /opt/upgrade/easysuite_upgrade/workpath/V100R019C00SPC602-V100R020C00/workpath-NCE/"
        return 1
    fi
}

# 刷新备份恢复数据库信息
function fresh()
{
    PRODUCTNAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    if [ -z "${PRODUCTNAME}" ]
    then
        LOG "ERROR" "Failed to obtain product information."
        return 1
    fi
    LOG "INFO" "Start to upgdate productext's key(optionalFunctionEnable)."
    python >>"${LOG_FILE}" 2>&1 << PEND
import os
import sys
import json
import time
import shutil
product_name = "${PRODUCTNAME}"
oss_root = os.getenv('OSS_ROOT')
if not os.path.isdir(oss_root):
    print("OSS_ROOT(%s) is not exit." % oss_root)
    sys.exit(1)
time_stamp = int(time.time())
work_path = "${LOG_PATH}"
out_path = f"{work_path}/{time_stamp}_modify_productext_key"
if os.path.isdir(out_path):
    shutil.rmtree(out_path)
os.makedirs(out_path)
product_json = os.path.join(out_path, "product_%s.json" % product_name)
query_product_cmd = "bash %s/tools/resmgr/queryproduct.sh -pn %s -output %s" \
                            % (oss_root, product_name, out_path)
modify_product_cmd = "bash %s/tools/resmgr/modifyproductinfo.sh -input %s" \
                             % (oss_root, product_json)
result = os.system(query_product_cmd)
if result != 0:
    print("query_product_cmd:%s,result:%s" % (query_product_cmd, result))
    sys.exit(1)
if not os.path.isfile(product_json):
    print("product_json:%s is not exit" % product_json)
    sys.exit(1)
with open(product_json, 'r', encoding='utf-8') as r_stream:
    product_data = json.load(r_stream)
    if 'mgmtSize' not in product_data.get('productext').keys() and 'optionalFuntionEnable' not in product_data.get('productext').keys():
        print("The key:mgmtSize and optionalFuntionEnable not exist, skip update.")
        sys.exit(0)
    if 'mgmtSize' in product_data.get('productext').keys():
        print("The mgmtSize is exist.")
        product_data.get('productext').update({'NCE_mgmtSize':product_data.get('productext').get('mgmtSize')})
    if 'optionalFuntionEnable' in product_data.get('productext').keys():
        print("The optionalFuntionEnable is exist.")
        product_data.get('productext').update({'optionalFunctionEnable':product_data.get('productext').pop('optionalFuntionEnable')})
with open(product_json, 'w', encoding='utf-8') as w_stream:
    w_stream.write(json.dumps(product_data))
result = os.system(modify_product_cmd)
if result != 0:
    print("modify_product_cmd:%s,result:%s" % (modify_product_cmd, result))
    sys.exit(1)
if os.path.isdir(out_path):
    print("clear out_path:%s" % out_path)
    shutil.rmtree(out_path)
PEND
    if [ $? -eq 1 ]
    then
        LOG "ERROR" "Failed to upgdate productext's key(optionalFunctionEnable)."
        return 1
    fi
    LOG "INFO" "Finished to upgdate productext's key(optionalFunctionEnable)."
}

function main()
{
    check_user || return 1
    # 创建日志目录
    [ ! -d "${LOG_PATH}" ] && mkdir -p ${LOG_PATH}
    . /opt/oss/manager/bin/engr_profile.sh
    check_input "$@" || return 1
    fresh || return 1
}

main "$@"
exit $?