# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2020-01-04 创建
"""
import os
import re
import time
import shutil


class Logger:
    """
    功能描述：日志记录公共类
    """
    instance = None

    def __init__(self):
        """
        功能描述：初始化日志配置
        修改记录：新增方法
        """
        self.logfile = ""
        self._logpath = "/opt/oss/log/manager/easysuite_upgrade"
        maxfilesize = 20
        maxbackupcount = 10
        self._maxsize = maxfilesize * 1048576
        self._maxnum = maxbackupcount
        _pstring = '/opt/oss|/opt/upgrade|password|passwd|pwd|password(.*)=(.*)|passwd(.*)=(.*)' \
                   '|license(.*)=(.*)|([A-Fa-f0-9]{2}\\:){5}[A-Fa-f0-9]{2}'
        self._pattern = re.compile(_pstring, re.IGNORECASE)
        if not os.path.isabs(self._logpath):
            raise IOError
        try:
            if not os.path.isdir(self._logpath):
                os.umask(23)
                os.makedirs(self._logpath, 488)
        except IOError as ex:
            print("Exception:commonlog.py init IOError")

    def getinstance(self, _logname):
        """
        功能描述：返回对象
        参数：logname
        修改记录：新增方法
        """
        if self.instance is None:
            if _logname.find("/") >= 0:
                _modulename = _logname.split("/")[-1]
            else:
                _modulename = _logname
            self.logfile = '%s' % self._logpath + os.sep + '%s.log' % _modulename
            if os.path.exists(self.logfile):
                os.chmod(self.logfile, 416)
            self.instance = self
        return self.instance

    def info(self, _infomsg):
        """
        功能描述：记录info级别日志
        参数：_infomsg
        修改记录：新增方法
        """
        self._writelog(_infomsg, 'INFO')

    def warning(self, _infomsg):
        """
        功能描述：记录warn级别日志
        参数：_infomsg
        修改记录：新增方法
        """
        self._writelog(_infomsg, 'WARNING')

    def error(self, _infomsg):
        """
        功能描述：记录error级别日志
        参数：_infomsg
        修改记录：新增方法
        """
        self._writelog(_infomsg, 'ERROR')

    def critical(self, _infomsg):
        """
        功能描述：记录critical级别日志
        参数：_infomsg
        修改记录：新增方法
        """
        self._writelog(_infomsg, 'CRITICAL')

    def debug(self, _infomsg):
        """
        功能描述：记录critical级别日志
        参数：_infomsg
        修改记录：新增方法
        """
        self._writelog(_infomsg, 'DEBUG')

    def _processlogfile(self):
        """
        功能描述：绕接日志文件
        参数：无
        修改记录：新增方法
        """
        os.umask(23)
        if not os.path.isfile(self.logfile):
            return
        logsize = os.path.getsize(self.logfile)
        if logsize <= self._maxsize:
            return
        maxcount = self._maxnum
        tmplogfile = self.logfile + '.%s' % maxcount
        if os.path.exists(tmplogfile):
            try:
                os.remove(tmplogfile)
            except IOError as ex:
                print("IOError Exception")
        _curcount = maxcount - 1
        while _curcount > 0:
            tmplogfile = self.logfile + '.%s' % _curcount
            if os.path.exists(tmplogfile):
                newlogfile = self.logfile + '.%s' % (_curcount + 1)
                try:
                    os.rename(tmplogfile, newlogfile)
                except IOError as ex:
                    print("IOError Exception")
            _curcount = _curcount - 1
        try:
            shutil.copy(self.logfile, self.logfile + '.1')
            fobj = os.fdopen(os.open(self.logfile,
                                     os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                                     mode=0o660), 'w')
            fobj.close()
        except IOError as ex:
            print("IOError Exception")
        return

    def _writelog(self, msg, loglevel):
        """
        功能描述：写入日志信息到文件
        参数：msg loglevel
        修改记录：新增方法
        """
        self._processlogfile()
        nowtime = time.strftime('%Y-%m-%d %H:%M:%S')
        pid = os.getpid()
        msg = re.sub(self._pattern, '{pvalue}', msg)
        logstr = '[%s] [%d] [%s] %s' % (nowtime, pid, loglevel, msg)
        try:
            fobj = os.fdopen(os.open(self.logfile, os.O_CREAT | os.O_WRONLY | os.O_APPEND,
                                     mode=0o660), 'a')
            fobj.write('%s%s' % (logstr, os.linesep))
            fobj.flush()
            fobj.close()
        except IOError as ex:
            print("IOError Exception")
        return
