# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import getopt
import inspect
import os
import sys
from datetime import datetime

from commonlog import Logger
from taskmgr_util import Taskmgrutil
from uniep_taskmgr import Unieptaskmgr

logger = Logger().getinstance(sys.argv[0])


class OperateDbpatch:
    @staticmethod
    def get_function_name():
        '''获取正在运行函数(或方法)名称'''
        return inspect.stack()[1][3]

    def fresh_db_patch(self, action_type, productname, pkgname):
        """
        功能描述：刷新数据库补丁安装状态
        参数：无
        返回： dbpwd
        修改记录：新增方法
        """
        command = "bash %s/modify_flag.sh %s %s %s" % (os.path.join(sys.path[0], ".."),
                                                       action_type, productname, pkgname)
        result = os.system(command)
        logger.info("[%s] Result:%s" % (self.get_function_name(), result))

    @staticmethod
    def upgrade_dbpatch(productname, pkgname, task_path, options=None):
        """
        功能描述：安装数据库补丁
        参数：productname, pkgname, operation
        返回： response
        修改记录：新增方法
        """
        if pkgname.endswith('_pkg.tar'):
            pkgname = pkgname.replace('_pkg.tar', '.tar.gz')
        unieptask_function = Unieptaskmgr()
        operation = "INSTALL"
        dbpatch_url = "/rest/plat/patchmgmtservice/v1/patchmgmt"
        params = {
            "ProductList": "[\"" + productname + "\"]",
            "ignoreServiceStatus": "TRUE",
            "PatchName": pkgname,
            "OperationType": operation,
            "APPAutoOpt": "0",
            "DBAutoOpt": "0"
        }
        ans = [(key[2:], value) for key, value in options if key.startswith("--")]
        params.update(dict(ans))
        for _ in range(1, 30):
            retstatus, response = unieptask_function.send_post_request(dbpatch_url, params)
            if retstatus is True:
                break
        if retstatus is True:
            wait_result = unieptask_function.wait_uniep_task(response, task_path)
        else:
            wait_result = False
        if wait_result is False:
            # 失败直接设置进度为100
            # 任务状态为失败
            finish_time = datetime.strptime(datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                                            '%Y-%m-%d %H:%M:%S')
            Taskmgrutil.set_msg_append(task_path,
                                       "[%s]" % finish_time + " " + Taskmgrutil.get_res_dict().get(
                                           "db_up_fail"))
            Taskmgrutil.set_e_taskstatus(task_path, "fail")
            Taskmgrutil.set_e_taskprogress(task_path, "100")
        else:
            finish_time = datetime.strptime(datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                                            '%Y-%m-%d %H:%M:%S')
            Taskmgrutil.set_msg_append(task_path,
                                       "[%s]" % finish_time + " " + Taskmgrutil.get_res_dict().get(
                                           "db_up_success"))
            Taskmgrutil.set_e_taskstatus(task_path, "success")
            Taskmgrutil.set_e_taskprogress(task_path, "100")
        return wait_result

    def rollback_dbpatch(self, productname, pkgname, task_path):
        """
        功能描述：预留补丁回滚，测试先直接刷新数据库状态
        参数：productname, pkgname, operation
        返回： response
        修改记录：新增方法
        """
        if pkgname.endswith('_pkg.tar'):
            pkgname = pkgname.replace('_pkg.tar', '.tar.gz')
        self.fresh_db_patch("uninstall", productname, pkgname)
        Taskmgrutil.set_e_taskstatus(task_path, "success")
        Taskmgrutil.set_e_taskprogress(task_path, "100")

    def operate_dbpatch(self, productname, pkgname, operation, task_path, options=None):
        """
        功能描述：操作db补丁
        参数：productname, pkgname, operation
        返回： response
        修改记录：新增方法
        """
        if operation == "INSTALL":
            self.upgrade_dbpatch(productname, pkgname, task_path, options=options)
        else:
            self.rollback_dbpatch(productname, pkgname, task_path)
        return True


def main(argv):
    operation = argv[1]
    productname = argv[2]
    pkgname = argv[3]
    e_task_id = argv[4]
    options, args = getopt.getopt(sys.argv[5:], "",
                                  ["APPAutoOpt=",
                                   "DBAutoOpt=",
                                   "ignoreServiceStatus=",
                                   "OperationType="])

    e_taskmgr_path = "/opt/upgrade/easysuite_upgrade/taskmgr"
    e_task_path = os.path.join(e_taskmgr_path, e_task_id)

    # 初始化方法
    taskmgr_function = Taskmgrutil()
    dbpatch_function = OperateDbpatch()

    # 初始化任务
    taskmgr_function.init_e_taskmgr(e_task_path)

    if operation == "upgrade":
        dbpatch_function.operate_dbpatch(productname, pkgname,
                                         "INSTALL", e_task_path, options=options)
    else:
        dbpatch_function.operate_dbpatch(productname, pkgname,
                                         "ROLLBACK", e_task_path)
    return 0


if __name__ == '__main__':
    main(sys.argv)
