# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import datetime
import json
import os
import sys
import time
from commonlog import Logger

LOGGER = Logger().getinstance(sys.argv[0])
config_dir = "/opt/oss/log/manager/easysuite_upgrade_config"


class OperateSchedule:
    """
    更新平台定时任务状态
    """

    def __init__(self, workpath, script_id):
        self.oss_root = os.getenv("OSS_ROOT")
        if not self.oss_root:
            self.oss_root = "/opt/oss/manager"
        self.schedule_data = {}
        self.oss_lang = os.getenv("OSS_LANG")
        if self.oss_lang == "zh_CN":
            self.oss_lang = "zh_CN"
        else:
            self.oss_lang = "en_US"
        self.set_task_data = {
            "jobId": "",
            "startTime": "",
            "intervalDay": "",
            "isenabled": "",
            "endTime": "",
            "remark": "",
            "language": self.oss_lang,
            "interval": ""
        }
        self.operate_recoed = f"/opt/oss/log/manager/easysuite_upgrade/{workpath}_record.log"
        self.script_id = script_id
        self.log_path = f"/opt/oss/log/manager/easysuite_upgrade/{os.path.basename(__file__)}.log"

        # 升级任务关闭id列表
        self.disable_list = []
        # 上次任务已经关闭的任务id列表
        self.tmp_disable_list = []
        # 需要开启的任务列表
        self.enable_list = []

    def query_schedule_task(self):
        """
        调用平台接口查询定时任务
        """
        ret_code = 0
        query_schedule_json = "%s/query_schedule_task.json" % config_dir
        if os.path.exists(query_schedule_json):
            os.remove(query_schedule_json)
        shell_cmd = 'bash %s/agent/BackupService/bin/queryScheduleTask.sh -pn all -output %s' % (
            self.oss_root, query_schedule_json)
        for try_count in range(0, 5):
            ret_code = os.system("%s >>%s 2>&1" % (shell_cmd, self.log_path))
            if try_count == 4 or ret_code == 0:
                break
            time.sleep(1)
        if ret_code != 0:
            LOGGER.error("Failed to execute queryScheduleTask.sh, return code:{}".format(ret_code))
            return False
        if not os.path.isfile(query_schedule_json):
            LOGGER.error("Failed to find %s/query_schedule_task.json" % config_dir)
            return False
        with open(query_schedule_json, 'r') as result_file:
            self.schedule_data = json.load(result_file)
            LOGGER.info("Query info:{}".format(self.schedule_data))
        return True

    def modify_one_record(self, one_sch_task, action="enable"):
        """
        禁用或者解禁单条定时任务
        """
        ret_code = 0
        new_schedule_task = "%s/new_schedule_task.json" % config_dir
        LOGGER.info("Original Information:{}".format(one_sch_task))
        if self.set_task_data.get("isenabled") == one_sch_task.get("isenabled"):
            return True
        job_id = self.get_schedule_task_config(action, new_schedule_task, one_sch_task)
        shell_cmd = 'bash %s/agent/BackupService/bin/modifyScheduleTask.sh -input %s 2>&1' % (
            self.oss_root, new_schedule_task)
        for try_count in range(0, 5):
            ret_code = os.system("%s >>%s 2>&1" % (shell_cmd, self.log_path))
            if try_count != 4 and ret_code != 0:
                with os.fdopen(os.open(new_schedule_task,
                                       os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                                       mode=0o660), "w") as modify_file:
                    json.dump(self.set_task_data, modify_file, indent=4)
                time.sleep(1)
                continue
            if action == "disable" and ret_code == 0:
                self.disable_list.append(job_id)
            break
        if os.path.isfile(new_schedule_task):
            os.remove(new_schedule_task)
        if ret_code != 0:
            LOGGER.error(
                "Failed to execute modifyScheduleTask.sh, return code:{}".format(ret_code))
            return False
        return True

    def get_schedule_task_config(self, action, new_schedule_task, one_sch_task):
        """
        功能说明:获取定制任务相关配置
        :param action:
        :param new_schedule_task:
        :param one_sch_task:
        :return:
        """
        job_id = one_sch_task.get("jobId")
        # 时间比对,延时一个小时,避免刚好卡在定时任务触发时间点启用或禁用对应任务
        now_utc_time = datetime.datetime.utcnow() + datetime.timedelta(hours=1)
        task_str_time = one_sch_task.get("startTime")
        hour_str_time = task_str_time.split(" ")[-1]
        next_day_time = datetime.datetime.strftime(
            datetime.datetime.utcnow() + datetime.timedelta(days=1), '%Y-%m-%d')
        format_task_str_time = datetime.datetime.strptime(task_str_time, '%Y-%m-%d %H:%M:%S')
        # 当前世界协调时要早于传入的时间1min以上，否则会导致调用接口报错
        if now_utc_time >= format_task_str_time - datetime.timedelta(minutes=5):
            self.set_task_data.update({"startTime": "%s %s" % (next_day_time, hour_str_time)})
        else:
            self.set_task_data.update({"startTime": task_str_time})
        if 'jonId' in one_sch_task.keys():
            self.set_task_data.update({"jobId": one_sch_task.get("jonId")})
        else:
            self.set_task_data.update({"jobId": one_sch_task.get("jobId")})
        self.set_task_data.update({"intervalDay": one_sch_task.get("intervalDay")})
        self.set_task_data.update({"remark": one_sch_task.get("remark")})
        self.set_task_data.update({"interval": one_sch_task.get("interval")})
        LOGGER.info("Modify Information:{}".format(self.set_task_data))
        with os.fdopen(os.open(new_schedule_task,
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=0o660), "w") as modify_file:
            json.dump(self.set_task_data, modify_file, indent=4)
        return job_id

    def modify_record_list(self, action):
        """
        功能描述：记录定时任务列表
        :param action: 禁用时才写入
        :return:
        """
        try:
            if action == "disable":
                LOGGER.info("Disable list:{}".format(self.disable_list))
                tmp_list = list(
                    set(self.tmp_disable_list).union(set(self.disable_list)))
                tmp = dict()
                tmp[self.script_id] = tmp_list
                with os.fdopen(os.open(self.operate_recoed,
                                       os.O_CREAT | os.O_WRONLY | os.O_TRUNC, mode=0o660), "w") as file:
                    json.dump(tmp, file)
            return True
        except (IOError, ValueError, TypeError) as e_msg:
            LOGGER.error("Failed to write disable list. Exception:{}".format(e_msg))
            return False

    def modify_schedule_task(self, action="enable"):
        """
        功能描述：关闭未关闭的定时任务/开启easysuite关闭的定时任务
        参数：action "enable"/"disable"
        返回值：True/False
        """
        if not self.query_schedule_task():
            return False

        tmp_info = {}
        try:
            if os.path.isfile(self.operate_recoed):
                with open(self.operate_recoed, "r") as file:
                    tmp_info = json.load(file)
        except (TypeError, ValueError, IOError) as e_msg:
            LOGGER.warning(
                "Failed to load task information. Exception:{}".format(e_msg))

        if action == "enable":
            for value in tmp_info.values():
                self.enable_list += value
        else:
            self.tmp_disable_list = tmp_info.get(self.script_id, [])

        if self.enable_list:
            LOGGER.info("Enable list:{}".format(self.enable_list))
        flag = True
        for one_sch_task in self.schedule_data:
            job_id = one_sch_task.get("jobId")
            if action == "enable" and job_id not in self.enable_list:
                continue
            if action != "enable" and job_id in self.tmp_disable_list:
                continue
            try:
                result = self.modify_one_record(one_sch_task, action)
            except (IOError, ValueError, TypeError) as e_msg:
                LOGGER.error(
                    "Failed to modify schedule task. Exception:{0}".format(e_msg))
                result = False
            if result:
                continue
            else:
                flag = False

        self.modify_record_list(action)

        return flag

    def disable_schedule_task(self):
        """
        禁用定时任务
        """
        # 禁用任务任务状态 isenabled : 0
        self.set_task_data.update({"isenabled": "0"})
        if not self.modify_schedule_task("disable"):
            return False
        return True

    def enable_schedule_task(self):
        """
        启用定时任务
        """
        # 启用任务任务状态 isenabled : 0
        self.set_task_data.update({"isenabled": "1"})
        if not self.modify_schedule_task("enable"):
            return False
        if os.path.isfile(self.operate_recoed):
            os.remove(self.operate_recoed)
        return True


def main(argv):
    """
    主程序入口，启停备份定时任务
    """
    action = argv[1]
    workpath = argv[2]
    script_id = argv[3]
    schedule_function = OperateSchedule(workpath, script_id)
    if not os.path.isdir(config_dir):
        os.makedirs(config_dir)
    if action == "enable":
        operate_result = schedule_function.enable_schedule_task()
    else:
        operate_result = schedule_function.disable_schedule_task()
    if not operate_result:
        return False
    return True


if __name__ == '__main__':
    if main(sys.argv):
        sys.exit(0)
    else:
        sys.exit(1)
