#!/bin/bash
WORKFORDER=$(dirname $(readlink -f $0))
RESULT_FILE="/tmp/os_partition_check_result"
SUDO_PKG="/tmp/sudobin_pkg.tar"
LOG_FILE="/var/log/check_os_partition.log"

function check_os_partition(){
    [ -f ${LOG_FILE} ] && rm -f ${LOG_FILE}
    [ -f ${RESULT_FILE} ] && rm -f ${RESULT_FILE}
    local flag="true"
    
    # 查询系统上的磁盘
    disks=$(lsblk -o name,rm,ro,type -n|awk '{if ($2==0 && $3==0 && $4=="disk"){print $1}}' | xargs)
    # 对每块磁盘的分区进行检查
    for disk in ${disks}
    do
        # 磁盘上的所有分区
        partitions=$(blkid | grep "/dev/${disk}" | awk -F":" '{print $1}' | xargs)
        # 获取分区表类型
        fdisk -l /dev/${disk} 2>>/dev/null | grep "label" | grep gpt &>> ${LOG_FILE}
        is_gpt_res=$?
        # 检查磁盘分区表是否存在此分区
        for partition in ${partitions}
        do
            # gpt分区表检查
            if [ ${is_gpt_res} -eq 0 ];then
                fdisk -l "/dev/${disk}" | grep "Start" -A 10 | awk -F " " '{print $1}' | grep ${partition: -1} &>> ${LOG_FILE}
                check_result=$?
            else
                fdisk -l "/dev/${disk}" | grep -w ${partition} &>> ${LOG_FILE}
                check_result=$?
            fi
            if [ ${check_result} -ne 0 ]
            then
                flag="false"
                echo "The partition ${partition} is not found in the partition table." >> "${RESULT_FILE}"
            fi
        done
    done

    if [ ${flag} != "true" ]
    then
        sed -i "1i OS partition check failed." "${RESULT_FILE}"
    else
        echo "check successfully" > "${RESULT_FILE}"
    fi
    #修改权限，使ossadm用户可读
    chmod 644 ${RESULT_FILE}
}

function clean_env(){
    rm -rf ${SUDO_PKG}
}

function main(){
    check_os_partition
    clean_env
}

main "$*"
