#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

function main()
{
    action="${1}"
    productname="${2}"
    success_flag==/opt/upgrade//success.flag
    echo "1">"${success_flag}"
    id sopuser 2>/dev/null | setfacl -m u:sopuser:r-x /opt/upgrade/success.flag
    . /opt/oss/manager/bin/engr_profile.sh
    if [ "${action}" == "start" ]
    then
        ipmc_adm -cmd startnodes -tenant ${productname} -type app
        result=$?
    else
        ipmc_adm -cmd stopnodes -tenant ${productname} -type app
        result=$?
    fi
    if [ ${result} -eq 0 ]
    then
        echo "100">/opt/upgrade/success.flag
    else
        echo "fail">/opt/upgrade/success.flag
    fi
}

main $@ >/dev/null 2>&1 &
exit 0