# encoding=utf-8
"""
功 能：删除旧版本license文件
版权信息：华为技术有限公司，版本所有(C) 2020-2029
修改记录：2020-09-09 12:00 创建
"""
import os
import sys
import json
import time
from util import common
from util import httpclient
from commonlog import Logger

LOGGER = Logger().getinstance(sys.argv[0])
OSS_ROOT = os.popen("echo $OSS_ROOT").read().strip()
SERVICE_NAME = "SMPManagerService"
QUERY_TOKENS_URL = "/rest/sia/v1/tokens/jwt/sia"
ADD_LICENSE_URL = "/rest/plat/license/v1/licensefile/action?action-id=directImport"
PRODUCT_NODE_LIST = []
NO_SIA = "with_out_sia"


def get_product_node_ip(count_len=False):
    """
    功能描述：获取产品服务节点
    :return:
    """
    LOGGER.info("[add_new_license.get_product_node_ip] Get product node info.")
    if not PRODUCT_NODE_LIST:
        url = '/rest/plat/omp/v1/main/resmgr/nodes'
        result = httpclient.IRHttpClient().get(url)
        if not isinstance(result, tuple) and result[0] != 200:
            LOGGER.error("[add_new_license.get_product_node_ip]"
                         " get url: %s, result: %s." % (url, str(result)))
            return ""
        node_info_list = json.loads(result[1])
        for node_info in node_info_list:
            result_node_name = node_info.get("nodeName", "")
            result_node_ip = node_info.get("manageIP", "")
            if result_node_name.lower().find("gw") != -1:
                continue
            PRODUCT_NODE_LIST.append({
                "node_name": result_node_name,
                "manage_ip": result_node_ip
            })
        LOGGER.info("[add_new_license.get_product_node_ip] product all node list: %s." % PRODUCT_NODE_LIST)
        if count_len:
            return len(PRODUCT_NODE_LIST)
    result = PRODUCT_NODE_LIST.pop()

    LOGGER.info("[add_new_license.get_product_node_ip]"
                " result node:%s, IP:%s." % (result["node_name"], result["manage_ip"]))
    return result["manage_ip"]


def get_service_jwt():
    """
    功能描述：获取jwt配置信息
    :return:
    """
    jwt_file = "%s/apps/%s/etc/authconf/jwt/jwt_%s.json" % (OSS_ROOT, SERVICE_NAME, SERVICE_NAME)
    if not os.path.isfile(jwt_file):
        LOGGER.error("[add_new_license.get_service_jwt]"
                     " The %s file does not exist." % str(jwt_file))
        return {}
    with open(jwt_file, "r") as fob:
        file_dict = json.load(fob)
        file_dict.update({
            "domain": SERVICE_NAME
        })
    return file_dict


def get_sia_token():
    """
    功能描述：获取token配置信息
    :return:
    """
    jwt_config = get_service_jwt()
    if not jwt_config:
        LOGGER.error("[add_new_license.get_sia_token] No sia")
        # 无鉴权文件,无SIA方式调用
        return NO_SIA
    if "jwt" in jwt_config and "domain" in jwt_config:
        local_node_ip = common.getLocalIP() if hasattr(common, 'getLocalIP') else \
            common.get_local_ip()
        client = httpclient.CommonHttpClient(local_node_ip, 32038, True, False)
        result = client.post(QUERY_TOKENS_URL, jwt_config)
        if not isinstance(result, tuple) and result[0] != 200:
            LOGGER.error("[add_new_license.get_sia_token]"
                         f" post url: {QUERY_TOKENS_URL}, result: {result}.")
            return ""
        if result != 200:
            LOGGER.error("[add_new_license.get_sia_token] "
                         f"No sia.Post url:{QUERY_TOKENS_URL}, result: {result}.")
            # 请求非 200 按无SIA方式调用
            return NO_SIA
        token = json.loads(result[1])
        if "token" in token:
            return token.get("token", "")
    LOGGER.error("[add_new_license.get_sia_token] jwt_config: %s." % str(jwt_config))
    return ""


def init_common_client(product_node_ip, token_config):
    """
    功能描述：初始化query连接
    :param product_node_ip:
    :param token_config:
    :return:
    """
    if token_config != NO_SIA:
        headers = {
            "x-access-token": token_config
        }
        return httpclient.CommonHttpClient(product_node_ip, 32018, True, False, headers=headers)
    return httpclient.CommonHttpClient(product_node_ip, 32018, True, False)


def add_LICIMaster(common_client, licenseObjectStr, updateMode):
    """
    功能描述：添加新版本license
    :param common_client:
    :param licenseObjectStr:
    :param updateMode:
    :return:
    """
    # 不同返回值,前端打印不同日志信息
    if licenseObjectStr is None:
        LOGGER.error("[add_new_LICiMaster.add_LICiMaster] licenseObjectStr is None!")
        return 8
    param = {"licenseObjectStr": licenseObjectStr, "updateMode": updateMode}
    result = common_client.post(ADD_LICENSE_URL, param)
    if not isinstance(result, tuple):
        LOGGER.error("[add_new_LICiMaster.add_LICiMaster] result is not tuple!")
        return 9
    if result[0] == 400:
        LOGGER.error("[add_new_LICIMaster.add_LICIMaster] "
                     f"Failed to add the new LICIMaster, result: {result}.")
        return 4
    if result[0] == 406:
        LOGGER.error("[add_new_LICIMaster.add_LICIMaster] "
                     f"Failed to add the new LICIMaster, result: {result}.")
        return 6
    if result[0] == 500:
        LOGGER.error("[add_new_LICIMaster.add_LICIMaster] "
                     f"Failed to add the new LICIMaster, result: {result}.")
        return 5
    if result[0] == 200:
        LOGGER.info("[add_new_LICIMaster.add_LICIMaster] INFO :"
                    f" The LICIMaster of the new version is added successfully, result: {result}")
        return 0
    return 10


def FromParamGetArgs(arg):
    if not isinstance(arg, str):
        return None, None
    arg_list = arg.split("+")
    return f"/opt/upgrade/{arg_list[0]}", arg_list[1]


def main(argv):
    """
    功能描述：程序入口
    :param argv:
    :return:
    """
    # 获取添加字符串的必要参数
    # 不同返回值,前端打印不同日志信息
    license_path, update_mode = FromParamGetArgs(argv[1])
    try:
        with open(license_path, 'r') as f:
            license_str = f.read()
    except FileNotFoundError as e:
        LOGGER.error(f"[add_new_license.main] {str(e)}")
        return 1
    except UnicodeDecodeError as e:
        LOGGER.error(f"[add_new_license.main] {str(e)}")
        return 2
    except Exception as e:
        LOGGER.error(f"[add_new_license.main] {str(e)}")
        return 10

    # 获取环境token信息
    token_config = get_sia_token()
    if not token_config and token_config != NO_SIA:
        LOGGER.error("[add_new_license.main] Failed to obtain the token.")
        return 3

    common_client = None
    product_node_len = get_product_node_ip(count_len=True)
    for try_count in range(product_node_len):
        # 检查重试次数
        if try_count > product_node_len:
            return 7
        # 获取产品节点
        product_node_ip = get_product_node_ip()
        if product_node_ip == "":
            LOGGER.warning("[add_new_license.main] Failed"
                           " to obtain the IP address of the SMLog node.")
            time.sleep(3)
            continue

        # 初始化common_client连接
        common_client = init_common_client(product_node_ip, token_config)
        if common_client is None:
            LOGGER.warning("[add_new_license.main] Failed to init client.")
            time.sleep(3)
            continue
        break

    exec_result = add_LICIMaster(common_client, license_str, update_mode)
    return exec_result


if __name__ == '__main__':
    sys.exit(main(sys.argv))
