# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import os
import sys
import inspect
import time

from datetime import datetime
from commonlog import Logger
from uniep_taskmgr import Unieptaskmgr
from taskmgr_util import Taskmgrutil

RECORD_LOGGER = Logger().getinstance(sys.argv[0])


class OperateBigdata:
    """
    bigdata补丁任务操作
    """

    @staticmethod
    def get_function_name():
        """获取正在运行函数(或方法)名称"""
        return inspect.stack()[1][3]

    @staticmethod
    def operate_bigdata(productname, pkgname, operation, taskpath):
        """
        功能描述：下发bigdata补丁任务
        参数：productname, pkgname, operation
        返回： response
        修改记录：新增方法
        """
        unieptask_function = Unieptaskmgr()
        bigdata_url = "/rest/plat/patchmgmtservice/v1/patchmgmt"
        params = {
            "ProductList": "[\"" + productname + "\"]",
            "ignoreServiceStatus": "TRUE",
            "PatchName": pkgname,
            "OperationType": operation,
            "APPAutoOpt": "0",
            "DBAutoOpt": "0"
        }

        # 固定等待120秒 2分钟
        time.sleep(120)

        # 标记文件
        response_flag_file = os.path.join(taskpath, "response.flag")
        # 无标记文件时才会下发新的请求
        if not os.path.isfile(response_flag_file):
            RECORD_LOGGER.info("response.flag does not exist.")
            for _ in range(1, 30):
                retstatus, response = unieptask_function.send_post_request(bigdata_url, params)
                RECORD_LOGGER.info("send post_url:%s;OperationType:%s;retstatus:%s;response:%s." %
                                   (bigdata_url, operation, retstatus, response))
                if retstatus is True:
                    break
            if retstatus is False:
                return False
            # 调用成功，则将response存入taskpath目录下的标记文件response.flag
            with os.fdopen(os.open(response_flag_file,
                                   os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                                   mode=0o660), "wb") as flag_obj:
                flag_obj.write(response)
        else:
            RECORD_LOGGER.info("response.flag exist,will query by it")
        with open(response_flag_file, "rb") as flag_obj:
            response = flag_obj.read()
        wait_result = unieptask_function.wait_uniep_task(response, taskpath)
        RECORD_LOGGER.info("query progress by response:%s;wait_result is:%s" %
                           (response, wait_result))
        # 等待查询进度完成后，将标记文件删除
        if os.path.isfile(response_flag_file):
            os.remove(response_flag_file)

        if wait_result is False:
            # 失败直接设置进度为100
            # 任务状态为失败
            finish_time = datetime.strptime(datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                                            '%Y-%m-%d %H:%M:%S')
            Taskmgrutil.set_msg_append(taskpath, "[%s]" % finish_time + " " +
                                       Taskmgrutil.get_res_dict().get("bigdata_up_fail"))
            Taskmgrutil.set_e_taskstatus(taskpath, "fail")
            Taskmgrutil.set_e_taskprogress(taskpath, "100")
        else:
            finish_time = datetime.strptime(datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
                                            '%Y-%m-%d %H:%M:%S')
            Taskmgrutil.set_msg_append(taskpath, "[%s]" % finish_time + " " + Taskmgrutil.
                                       get_res_dict().get("bigdata_up_success"))
            Taskmgrutil.set_e_taskstatus(taskpath, "finish")
            Taskmgrutil.set_e_taskprogress(taskpath, "100")
        return wait_result


def main(argv):
    """
    main函数
    """
    operation = argv[1]
    productname = argv[2]
    pkgname = argv[3]
    e_task_id = argv[4]
    e_taskmgr_path = "/opt/upgrade/easysuite_upgrade/taskmgr"
    e_task_path = os.path.join(e_taskmgr_path, e_task_id)

    # 初始化方法
    bigdata_function = OperateBigdata()
    taskmgr_function = Taskmgrutil()

    # 初始化任务
    taskmgr_function.init_e_taskmgr(e_task_path)

    Taskmgrutil.set_e_taskstatus(e_task_path, "RUNNING")
    Taskmgrutil.set_e_taskprogress(e_task_path, "0")

    if operation == "upgrade":
        bigdata_function.operate_bigdata(productname, pkgname, "INSTALL", e_task_path)
    else:
        bigdata_function.operate_bigdata(productname, pkgname, "ROLLBACK", e_task_path)


if __name__ == '__main__':
    main(sys.argv)

