# encoding=utf-8
"""
功 能：记录日志
版权信息：华为技术有限公司，版本所有(C) 2019-2029
修改记录：2019-12-11 12:00 创建
"""
import os
import sys
import time
import shlex
import codecs
import subprocess
import configparser

from commonlog import Logger

logger = Logger().getinstance(sys.argv[0])


class Taskmgrutil:
    task_msg = ""

    @staticmethod
    def get_local_lang():
        local_lang = os.getenv("OSS_LANG")
        if not local_lang:
            local_lang = "en_US"
        elif local_lang == "zh_CN":
            local_lang = "zh_CN"
        else:
            local_lang = "en_US"
        return local_lang

    @staticmethod
    def get_res_dict():
        """
        功能描述：全量加载国际化资源文件
        返回值：国际化资源信息
        """
        # 默认使用英文
        local_lang = "en_US"
        res_dict = {}
        conf = configparser.RawConfigParser()
        local_file_dir = os.path.split(os.path.realpath(__file__))[0]
        res_file = os.path.join(local_file_dir, "..", "i18n", '%s.properties' % local_lang)
        if os.path.isfile(res_file):
            conf.read_file(codecs.open(res_file, "r", "utf-8-sig"))
            for section in conf.sections():
                for attr in conf.options(section):
                    res_dict.update({attr: conf.get(section, attr)})
        return res_dict

    @staticmethod
    def execute_cmd(cmd, timeout=3600):
        """
        功能描述：使用subprocess执行命令
        参数： cmd
        返回值: 返回码, 标准输出/标准错误
        """
        try:
            process = subprocess.Popen(shlex.split(cmd), shell=False, encoding='utf-8',
                                       stderr=subprocess.PIPE,
                                       stdout=subprocess.PIPE)
            stdout, stderr = process.communicate(timeout=timeout)
            code = process.returncode
            output = f"{os.linesep}stdout:{stdout}{os.linesep}stderr:{stderr}"
        except Exception as e:
            logger.warning("execute_cmd.exception:error.cmd:%s" % cmd)
            code = "201"
            output = "execute_cmd.exception"
        return code, output

    @staticmethod
    def set_e_taskstatus(task_id_path, status):
        """
        功能描述：设置任务状态
        参数：task_id_path,status
        返回： True/False
        修改记录：新增方法
        """
        with os.fdopen(os.open(os.path.join(task_id_path, "task.status"),
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=0o660), "w") as msg_obj:
            msg_obj.write("Status=%s" % status)
        return True

    @staticmethod
    def set_e_taskprogress(task_id_path, progress):
        """
        功能描述：设置任务进度
        参数：task_id_path,progress
        返回： True/False
        修改记录：新增方法
        """
        with os.fdopen(os.open(os.path.join(task_id_path, "task.progress"),
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC,
                               mode=0o660), "w") as msg_obj:
            msg_obj.write("Progress=%s" % progress)
        return True

    @staticmethod
    def read_linux_file(file_name):
        """
        功能描述：解析资源文件信息
        参数：file_name
        返回值：国际化资源信息
        """
        file_str = ""
        with open(file_name, 'r') as file_obj:
            while True:
                line = file_obj.readline()
                if not line:
                    break
                if line == "":
                    continue
                if line.endswith("\r\n"):
                    line = line.replace("\r\n", "")
                elif line.endswith("\n"):
                    line = line.replace("\n", "")
                if file_str == "":
                    file_str = line
                else:
                    file_str = "%s\n%s" % (file_str, line)
        return file_str

    @staticmethod
    def set_msg_overwrite(task_path, msg):
        if not msg.endswith("\n"):
            msg = "%s\n" % msg
        with os.fdopen(os.open(os.path.join(task_path, "task.log"),
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC, mode=0o660), "w") as msg_obj:
            msg_obj.write(msg)
        return True

    @staticmethod
    def set_msg_append(task_path, msg):
        if not msg.endswith("\n"):
            msg = "%s\n" % msg
        with os.fdopen(os.open(os.path.join(task_path, "task.log"),
                               os.O_CREAT | os.O_WRONLY | os.O_APPEND, mode=0o660), "a") as msg_obj:
            msg_obj.write(msg)
        return True

    def set_e_taskmsg(self, task_id_path, msg):
        """
        功能描述：设置任务进度
        参数：task_id_path,progress
        返回： True/False
        修改记录：新增方法
        """
        if self.task_msg.endswith("\r\n") or self.task_msg.endswith("\n"):
            msg = "%s%s" % (self.task_msg, msg)
        elif not self.task_msg:
            msg = "%s\n" % msg
        else:
            msg = "%s\n%s" % (self.task_msg, msg)
        with os.fdopen(os.open(os.path.join(task_id_path, "task.log"),
                               os.O_CREAT | os.O_WRONLY | os.O_TRUNC, mode=0o660), "w") as msg_obj:
            msg_obj.write(msg)
        return True

    def init_e_taskmgr(self, task_id_path):
        """
        功能描述：根据任务id，初始化easysuite任务管理
        参数：e_taskmgr_path,e_task_id
        返回： True/False
        修改记录：新增方法
        """
        ret_msg = ""
        old_msg_file_path = os.path.join(task_id_path, "task.log")
        if os.path.isfile(old_msg_file_path):
            self.task_msg = Taskmgrutil.read_linux_file(old_msg_file_path)
            ret_msg = self.task_msg
        if not os.path.isdir(task_id_path):
            os.mkdir(task_id_path)
            os.system("id sopuser 2>/dev/null | setfacl -m u:sopuser:r-x {}".format(task_id_path))
        else:
            os.system("rm -rf %s/*" % task_id_path)
        for task_file in ["task.log", "task.progress", "task.status"]:
            os_result = os.system("touch %s" % os.path.join(task_id_path, task_file))
            if os_result != 0:
                return False
            os.system("id sopuser 2>/dev/null | setfacl -m u:sopuser:r-- {}".
                      format(os.path.join(task_id_path, task_file)))
        Taskmgrutil.set_e_taskstatus(task_id_path, "RUNNING")
        Taskmgrutil.set_e_taskprogress(task_id_path, "0")
        return ret_msg

    @staticmethod
    def set_task(task_path, status='', progress='', msg=''):
        """
        功能说明：设置任务状态和信息
        :param task_path: 任务工作路径
        :param status: 任务状态
        :param progress: 任务进度
        :param msg: 任务详情
        :return:
        """
        if status:
            Taskmgrutil.set_e_taskstatus(task_path, status)
        if progress:
            Taskmgrutil.set_e_taskprogress(task_path, progress)
        if msg:
            msg = f"[{time.strftime('%Y-%m-%d %H:%M:%S')}] [{os.getpid()}] {msg}"
            Taskmgrutil.set_msg_append(task_path, msg)
