#!/bin/bash


function read_para() {
  stty -echo
  read -p "Please input the password of the ftpuser: " expand_disk_ftpuser_pwd
  echo ""
  stty echo
}


function get_path() {
    EXPAND_DISK_BASE_DIR=$(cd $(dirname $0);pwd)

    EXPAND_DISK_TEMP_DIR="${EXPAND_DISK_BASE_DIR}/expand_disk_temp_dir"
    EXPAND_DISK_LOG_DIR="${EXPAND_DISK_BASE_DIR}/log"
    CONFIG_BACKUP_SERVER_SCRIPT="${EXPAND_DISK_BASE_DIR}/config_backup_server.py"
    CONFIG_BACKUP_SERVER_PY="${EXPAND_DISK_TEMP_DIR}/config_backup_server.py"
    EXPAND_JSON_FILE="${EXPAND_DISK_TEMP_DIR}/backup_config_json.json"
    EXPAND_CURRENT_NODE_IP_JSON="${EXPAND_DISK_TEMP_DIR}/current_node_ip.json"
    CEHCK_SFTP_SCTIPT="${EXPAND_DISK_BASE_DIR}/check_sftp_pwd.sh"
    SFTP_SERVER_IP="${EXPAND_DISK_TEMP_DIR}/sftp_server_ip.txt"

    if [ -d "$EXPAND_DISK_TEMP_DIR" ];then
      rm -rf $EXPAND_DISK_TEMP_DIR
    fi
    mkdir -p $EXPAND_DISK_TEMP_DIR
    mkdir -p $EXPAND_DISK_LOG_DIR

    if [ ! -f "$CONFIG_BACKUP_SERVER_SCRIPT" ];then
      # py file not exist, pyc file
      CONFIG_BACKUP_SERVER_SCRIPT="${EXPAND_DISK_BASE_DIR}/config_backup_server.pyc"
      CONFIG_BACKUP_SERVER_PY="${EXPAND_DISK_TEMP_DIR}/config_backup_server.pyc"
    fi

    if [ ! -f "$CONFIG_BACKUP_SERVER_PY" ];then
      cp -f "$CONFIG_BACKUP_SERVER_SCRIPT" $EXPAND_DISK_TEMP_DIR
    fi
}

function init() {
  # logger file
  timeStamp=`date "+%Y%m%d%H%M%S"`
  logger_file="${EXPAND_DISK_LOG_DIR}/config_backup_server_${timeStamp}.log"

  # fail message
  modify_sftp_failed_message="Modify Config Backup Parameters failed. \
  Please login in the Management to check whether the scheduled backup task is being executed. \
  If yes, wait until the scheduled backup task is complete and execute the script again."
}

function logger() {
  local curtime=`date "+%Y-%m-%d %H:%M:%S"`
  echo "[$curtime] $*" >> $logger_file
}

function add_backup_flag() {
  # When modify the parameters of the backup server,
  # if the backup directory contains files but does not contain the backupflag file,
  # the modification fails.
  logger "Start to add backup flag"
  ftpuser_path=`cat /etc/passwd | grep '^ftpuser:' | awk -F ":" '{print($6)}'`
  backup_path="$ftpuser_path/backup"
  backup_flag="$backup_path/backupflag"

  logger "The backup path is $backup_path, the flag is $backup_flag"
  if [ ! -d "$backup_path" ];then
    mkdir -p $backup_path
    chown ftpuser:ossgroup $backup_path
    chmod 750 $backup_path
  fi

  if [ ! -f "$backup_flag" ];then
    touch $backup_flag
    chown ftpuser:ossgroup $backup_flag
    chmod 600 $backup_flag
  fi
  logger "Add backup path successful"
}

function modify_permission() {
  chown -R ossadm:ossgroup $EXPAND_DISK_TEMP_DIR
  chmod -R 750 $EXPAND_DISK_TEMP_DIR
}

function get_current_node_ip() {
  echo "Start to query sftp server ip"
  modify_permission
  su - ossadm -c ". /usr/local/osconfig/os/bin/getipinfo.sh -output $EXPAND_CURRENT_NODE_IP_JSON"
  if [ $? -ne 0 ];then
    logger "failed to get current node ip"
    return 1
  fi
  return 0
}

function query_and_generate_json() {
  echo "Start to generate the config sftp backup server parameter"
  modify_permission
  # query remote backup server infomation and generate json file to set globat para retry 3 times
  message="query remote backup server infomation and generate json file to set globat para"
  logger "start to ${message}"
  for ((index=0;index<3;index++))
  do
    result=`su - ossadm -c ". /opt/oss/manager/bin/engr_profile.sh; { \
    echo ${expand_disk_ftpuser_pwd}; echo ${EXPAND_CURRENT_NODE_IP_JSON}; \
    echo ${EXPAND_JSON_FILE};echo ${SFTP_SERVER_IP}; } | python ${CONFIG_BACKUP_SERVER_PY}"`
    if [ $? -ne 0 ];then
      logger "it is the ${index} time: failed to ${message},the result is $result"
    else
      echo "Generate the config sftp backup server parameter successful"
      logger "success to ${message},the result is $result"
      return 0
    fi
  done

  logger "failed to ${message}"
  echo "Failed to generate the config sftp backup server parameter"
  return 1
}

function check_sftp_pwd() {
  echo "Start to check the sftp password"
  sftp_ip=`cat $SFTP_SERVER_IP | grep ip | awk -F "=" '{print($2)}'`
  sftp_pwd=$expand_disk_ftpuser_pwd
  { echo ${sftp_ip}; echo ${sftp_pwd};} | bash $CEHCK_SFTP_SCTIPT
  if [ $? -eq 0 ];then
    echo "Check the sftp password successful"
    return 0
  fi
  for ((index=0;index<2;index++))
  do
    logger "Check sftp password failed, please check the password of the ftpuser and retry"
    echo "Check sftp password failed, please check the password of the ftpuser and retry"
    read_para
    sftp_pwd=$expand_disk_ftpuser_pwd
    { echo ${sftp_ip}; echo ${sftp_pwd};} | bash $CEHCK_SFTP_SCTIPT
    if [ $? -eq 0 ];then
      query_and_generate_json
      if [ $? -ne 0 ];then
        echo "Failed to generate the config sftp backup server parameter"
        return 1
      fi
      echo "Check the sftp password successful"
      return 0
    fi
  done
  echo "Check sftp pwd failed, please check the password of the ftpuser"
  return 1
}

function set_global_para() {
  echo "Start to modify the parameters of the scheduled backup server, this step will take several minutes. Please wait patiently"
  logger "start to set global para"
  modify_permission

  su - ossadm -c "cd /opt/oss/manager/tools/backuprestore/;./setglobalpara.sh -input ${EXPAND_JSON_FILE}"
  if [ $? -ne 0 ];then
    echo $modify_sftp_failed_message
    logger $modify_sftp_failed_message
    return 1
  fi
  logger "success to set global para"
  echo "Modify the parameters of the scheduled backup server successful"
  return 0
}

function del() {
  if [ -d "$EXPAND_DISK_TEMP_DIR" ];then
    rm -rf $EXPAND_DISK_TEMP_DIR
  fi
  return 0
}

function main() {
  read_para
  get_path
  init
  add_backup_flag
  get_current_node_ip
  if [ $? -ne 0 ];then
    return 1
  fi
  query_and_generate_json
  if [ $? -ne 0 ];then
    return 1
  fi
  check_sftp_pwd
  if [ $? -ne 0 ];then
    return 1
  fi
  set_global_para
  if [ $? -ne 0 ];then
    return 1
  fi

  del
  return 0
}

main
exit $?

