#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
OSS_USER=$(id -nu 3001)

####################################
# 检查备份服务器指定目录文件列表
####################################
function check_dst_task()
{
    local server_ip="$1"
    local server_user="$2"
    local ftp_pvalue="$3"
    local backup_path="$4"
    # 密码包含\,{,},[,],`,"时可以使变量前后命令失效，必须转义
    ftp_pvalue=$(echo ${ftp_pvalue} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    ipv6_flag=":"
    if [[ "$server_ip" =~ $ipv6_flag ]]
    then
          echo "server_ip is ipv6"
          server_ip="\[$server_ip\]"
        else
          echo "standby_node_ip is ipv4"
          server_ip="$server_ip"
    fi
    echo $server_ip
    expect <<END
        spawn sftp ${server_user}@${server_ip}
        set timeout -1
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send -- {${ftp_pvalue}};send -- \r;exp_continue}
        "*>" {send -- \r}
        }
        expect "*>"
        send "cd ${backup_path}\r"
        expect "*>"
        send "ls\r"
        expect "*>"
        send "exit\r"
        expect eof
END
}

####################################
# 下载备份服务器备份文件
####################################
function download_backup_pkg()
{
    local server_ip="$1"
    local server_user="$2"
    local ftp_pvalue="$3"
    local dst_backup_path="$4"
    local src_backup_path="$5"
    # 密码包含\,{,},[,],`,"时可以使变量前后命令失效，必须转义
    ftp_pvalue=$(echo ${ftp_pvalue} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    ipv6_flag=":"
    if [[ "$server_ip" =~ $ipv6_flag ]]
    then
          echo "server_ip is ipv6"
          server_ip="\[$server_ip\]"
        else
          echo "standby_node_ip is ipv4"
          server_ip="$server_ip"
    fi
    echo $server_ip
    expect <<END
        spawn sftp ${server_user}@${server_ip}
        set timeout -1
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send -- {${ftp_pvalue}};send -- \r;exp_continue}
        "*>" {send -- \r}
        }
        expect "*>"
        send "get ${dst_backup_path}/management.tar.gz ${src_backup_path}\r"
        expect "*>"
        send "get ${dst_backup_path}/management.tar.gz.sign ${src_backup_path}\r\r"
        expect "*>"
        send "exit\r"
        expect eof
END
}

function Main()
{
    read ftp_pvalue
    local server_ip=$1
    local server_user=$2
    local backup_path=$3

    # 获取所有的备份路径
    local check_dir="${backup_path}/management/management"
    local backup_list=$(check_dst_task ${server_ip} ${server_user} ${ftp_pvalue} ${check_dir} | egrep "[0-9]{15,}")

    # 获取备份管理面时间戳
    local latest_path="0"
    local backup_timestamp="/opt/upgrade/backup/backup_timestamp.properties"
    if [ -f "${backup_timestamp}" ]
    then
        local backup_data="$(grep 'backup_single_uniep_' ${backup_timestamp} | tail -n1 | sed 's/ //g')"
        local latest_path="$(echo ${backup_data} | awk -F: '{print $2}')"
    fi

    if [ "${latest_path}" == "0" ]
    then
        return 1
    fi

    local result=0
    local check_dir="${check_dir}/${latest_path}"
    OMP_NODE_NAME=$(bash ${SCRIPT_PATH}/restore_db_tool.sh get_manage_node)
    local backup_list=$(check_dst_task ${server_ip} ${server_user} ${ftp_pvalue} ${check_dir} | egrep ${OMP_NODE_NAME//,/|})
    for path in ${backup_list}
    do
        local path=$(echo ${path} | sed 's/\r//g')
        echo "${path}" | egrep ${OMP_NODE_NAME//,/|} &>/dev/null || continue
        local src_dir="/opt/upgrade/${path}"
        local dst_dir="${check_dir}/${path}"
        if [ -d ${src_dir} ]
        then
            rm -rf ${src_dir}
        fi
        mkdir -p ${src_dir} && chmod 750 ${src_dir} && chown ${OSS_USER}:ossgroup ${src_dir}
        download_backup_pkg  ${server_ip} ${server_user} ${ftp_pvalue} ${dst_dir} ${src_dir}
        
        if [ ! -f "${src_dir}/management.tar.gz" -o ! -f "${src_dir}/management.tar.gz.sign" ]
        then
            local result=1
        fi
    done
    return ${result}
}

Main $@
exit $?
