#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 获取节点登录信息
##################################################
function get_node_pwd()
{
    echo -n "es_input: node_pwd"
    read -s node_pwd
    # 密码包含\,{,},[,],`,"时可以使变量前后命令失效，必须转义
    node_pwd=$(echo ${node_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    export node_pwd=${node_pwd}
}

##################################################
# 主入口
##################################################
function main()
{
    node_ip="${1}"
    src_file="${2}"
    des_user="${3}"
    des_path="${4}"
    log_file="${5}"
    get_node_pwd
    if [[ "${node_ip}" =~ ":" ]]
    then
        node_ip="\[${node_ip}\]"
    fi
    expect <<END >"${log_file}"
        spawn scp "${src_file}" ${des_user}@${node_ip}:${des_path}
        set timeout -1
        expect {
        "*yes/no*" {send "yes\r";exp_continue}
        "*assword:" {send -- "${node_pwd}\r"}
        }
        expect eof
END
}

main "$@"
exit 0