#!/usr/bin/env bash

###############################################################################################
function fn_get_log_file_path()
{
    echo "${c_root_path}/cmd.repair.before.log"
    return 0
}

###############################################################################################
function fn_init()
{
    readonly c_root_path=$(dirname $(readlink -f $0 ))
    source ${c_root_path}/shscript/utils/load_all_util.sh
    fn_sys_set_logging_verbose "$SYS_LOGGING_INFO"
    readonly c_log_file="$(fn_get_log_file_path)"
    rm -f "${c_log_file}"
    fn_sys_create_log_file "$c_log_file"
    fn_sys_set_log_file "$c_log_file"
    readonly l_cluster_ini_file=`ls /opt/oss/share/*/NdpToolService/nce_inst.cfg`
    return 0
}

function fn_init_node_passwd()
{
    echo -n "Enter the password of the root user: "
    IFS=$'\n'
    read -sr remote_password
    echo -e "\n"
    echo "Start to prepare before repair ... "
}

###############################################################################################
# 1 执行用户是否是root
###############################################################################################
function fn_precheck()
{
    fn_info_screen "Precheck before restore."
    fn_sys_log_info "Precheck before restore."
    fn_sys_assert_current_user_matched "root" || return 1

    return 0
}

###############################################################################################
# 1 创建 ${root_path}/log 用于存放取回来的日志。
###############################################################################################
function fn_prepare()
{
    fn_info_screen "Prepare for pre-repair."
    fn_sys_log_info "Prepare for pre-repair."
    master_ip="$(cat "${l_cluster_ini_file}" | egrep '^Default=.*role=.*Manager1( |,|$)' | awk '{ for(i=1; i<=NF; i++) print $i }' | grep '^Base=' | awk -F'=' '{ print $2 }')"
    return 0
}

###################################################
#
# 执行远端命令
#
###################################################
function fn_run_command_remote()
{
    fn_info_screen "Start executing remote cmds."
    fn_sys_log_info "Start executing remote cmds."
    host_ip="$1"
    user="$2"
    passwd="$3"
    command="$4"
    timeout="$5"
    is_log="$6"
    exec_cmd_remote ${host_ip} ${user} "${timeout}" "${command}" ${is_log} << EOF
${passwd}
EOF
    result=$?
    [[ ${result} -ne 0 ]] && fn_sys_log_error "Failed to execute the remote command." && return ${result}
    fn_info_screen "Success to execute the remote command." && return 0
    fn_sys_log_info "Success to execute the remote command." && return 0
}

###############################################################################################
function fn_do()
{
    fn_info_screen "Start to do repair before..."
    fn_sys_log_info "Start to do repair before..."
    if [[ "${master_ip}" == "${restore_ip}" ]]; then
      rm -rf ${c_root_path}/conf/ldap
      rm -rf ${c_root_path}/conf/data
      mkdir -p ${c_root_path}/conf/ldap
      local system_type=$(cat /proc/version | grep "SUSE")
      if [[ -z "$system_type" ]];then
          cp /etc/sssd/sssd.conf ${c_root_path}/conf/ldap
      fi
      cp /etc/openldap/ldap.conf ${c_root_path}/conf/ldap
      mkdir -p ${c_root_path}/conf/data/ldap
      mkdir -p ${c_root_path}/conf/data/kerberos
      cp -r /opt/oss/share/*/NdpKerberosService/randomPass ${c_root_path}/conf/data/kerberos
      cp -r /opt/oss/share/*/NdpKerberosService/kstash ${c_root_path}/conf/data/kerberos
      cp -r /opt/oss/share/*/NdpLdapService/randomPass ${c_root_path}/conf/data/ldap
      cp -r /srv/BigData/ldapData ${c_root_path}/conf/data
    fi

    fn_sys_log_info "Start to touch repair flag."
    fn_run_command_remote ${restore_ip} "root" "${remote_password}" "touch /tmp/flag_restore_repair_node;" "5" "0"
    fn_run_command_remote ${restore_ip} "root" "${remote_password}" "chown 3004:2000 /tmp/flag_restore_repair_node;" "5" "0"
    fn_run_command_remote ${restore_ip} "root" "${remote_password}" "touch /tmp/flag_namenode_restore_repair_node;" "5" "0"
    fn_run_command_remote ${restore_ip} "root" "${remote_password}" "chown 3004:2000 /tmp/flag_namenode_restore_repair_node;" "5" "0"

    fn_info_screen "backup config files done."
    fn_sys_log_info "backup config files done."
    return 0
}

###############################################################################################
function fn_main()
{
    readonly c_start_time="$(date +%s)"
    restore_ip=${1}
    remote_password=" "
    fn_init || return 1
    fn_sys_log_enter
    fn_precheck || return 1
    fn_prepare || return 1
    fn_do || return 1

    local l_result="$?"
    local l_elapsed_seconds="$(fn_sys_get_elapsed_time "$c_start_time")"
    fn_sys_log_leave "Result [${l_result}]. It takes [${l_elapsed_seconds}] seconds"
    return "$l_result"
}
###############################################################################################

fn_main "$@"
result="$?"
exit "${result}"
