#!/bin/bash
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
LOG_PATH="/opt/upgrade/easysuite_upgrade/logs"
LOG_FILE="${LOG_PATH}/plandata_custom_sh.log"
CUR_PATH=$(dirname $(readlink -f $0))


##########################################
#初始化日志(处理日志绕接)
#@param
#   Level --日志级别
#   msg   --日志信息
##########################################
function LOG()
{
    msg="${2}"
    screenPrint="${3}"
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    if [ ! -d "${LOG_PATH}" ];then
        mkdir -p "${LOG_PATH}"
    fi
    if [ -f "${LOG_FILE}" ];then
        LOGSIZE=$(ls -l "${LOG_FILE}" |awk '{print $5}')
        if [ "${LOGSIZE}" -gt 5000000 ]; then
            echo "the LOG_FILE is :${LOG_FILE}">>"${LOG_FILE}"
            echo "LOGSIZE:${LOGSIZE}">>"${LOG_FILE}"
            Date=$(date '+%Y%m%d%H%M%S')
            echo "${Date}" >>"${LOG_FILE}"
            echo "Zip the log.">>"${LOG_FILE}"
            LOG_FILEBak="${LOG_FILE}.1"
            cp -p "${LOG_FILE}" "${LOG_FILEBak}"
            echo "Zip the log." >"${LOG_FILE}"
            gzip -f "${LOG_FILEBak}"
        fi
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${Level}] $2" >> "${LOG_FILE}"
}

main()
{
    LOG "INFO" "exec file ${SELF_FILE}"
    . /opt/oss/manager/bin/engr_profile.sh
    LOG "INFO" "$*"
    if [ ! -d "${INSTALL_ROOT}" ]
    then
        INSTALL_ROOT="/opt/oss"
    fi
    output_file=${4}
    cp -rf ${CUR_PATH}/*domain.json ${output_file}
    result=$?
    if [ ${result} -ne 0 ]
    then
        LOG "ERROR" "cp domain file failed."
        exit ${result}
    fi
    LOG "INFO" "exec file ${SELF_FILE} end"
}

main $*
exit $?