#!/bin/bash
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
LOG_PATH="/opt/upgrade/easysuite_upgrade/logs"
LOG_FILE="${LOG_PATH}/post_upgrade_sh.log"
CUR_PATH=$(dirname $(readlink -f $0))
SERVICE_NEED_RESTART=("HomePortalService")


##########################################
#初始化日志(处理日志绕接)
#@param
#   Level --日志级别
#   msg   --日志信息
##########################################
function LOG()
{
    msg="${2}"
    screenPrint="${3}"
    if [ "$1" = "ERROR" ];then
        Level="ERROR"
    elif [ "$1" = "WARN" ];then
        Level="WARN"
    else
        Level="INFO"
    fi
    if [ ! -d "${LOG_PATH}" ];then
        mkdir -p "${LOG_PATH}"
    fi
    if [ -f "${LOG_FILE}" ];then
        LOGSIZE=$(ls -l "${LOG_FILE}" |awk '{print $5}')
        if [ "${LOGSIZE}" -gt 5000000 ]; then
            echo "the LOG_FILE is :${LOG_FILE}">>"${LOG_FILE}"
            echo "LOGSIZE:${LOGSIZE}">>"${LOG_FILE}"
            Date=$(date '+%Y%m%d%H%M%S')
            echo "${Date}" >>"${LOG_FILE}"
            echo "Zip the log.">>"${LOG_FILE}"
            LOG_FILEBak="${LOG_FILE}.1"
            cp -p "${LOG_FILE}" "${LOG_FILEBak}"
            echo "Zip the log." >"${LOG_FILE}"
            gzip -f "${LOG_FILEBak}"
        fi
    fi
    echo "[$(date +%Y)-$(date +%m)-$(date +%d) $(date +%H):$(date +%M):$(date +%S)] [${Level}] $2" >> "${LOG_FILE}"
}

init_param()
{
    LOG "INFO" "start to init param"
    for i in {1..3}
    do
        [[ "${1}" == "-input" ]] && { INPUT_PATH=$2;shift 2;continue; }
        shift 2
    done
    LOG "INFO" "end to init param"
}

# 重启微服务
restart_app()
{
    LOG "INFO" "begin to restart app"
    # 查询微服务所在节点ip
    service_and_ip_str=""
    for service_name in ${SERVICE_NEED_RESTART[@]}
    do
        query_index=0
        query_times=3
        while [ $query_index -lt ${query_times} ]
        do
            service_query_ips=$(ipmc_adm -cmd statusapp -app ${service_name} -nodeip global | egrep -v 'No matched processes|All Processes|Process Name|^$' | awk '{print $6}' |tr '\n' ','|sed -e 's/,$//')
            if [ ! -z ${service_query_ips} ]
            then
                LOG "INFO" "${service_name} query ${query_index} time success"
                if [ -z ${service_and_ip_str}]
                then
                    service_and_ip_str="${service_name}|${service_query_ips}"
                else
                    service_and_ip_str="${service_and_ip_str}-${service_name}|${service_query_ips}"
                fi
                break
            fi
            sleep 30
            query_index=`expr $query_index + 1`
        done
        if [ -z ${service_query_ips} ]; then
            continue
        fi
    done
    LOG "INFO" "servcie and ips [${service_and_ip_str}]"
    # 重启节点上的微服务
    OLD_IFS="$IFS"
    IFS="-"
    service_and_ips=(${service_and_ip_str})
    IFS="$OLD_IFS"
    for service_and_ip in ${service_and_ips[@]}
    do
        OLD_IFS="$IFS"
        IFS="|"
        s_ips=(${service_and_ip})
        IFS="$OLD_IFS"
        ser_name=${s_ips[0]}
        ser_ip_str=${s_ips[1]}
        IFS=","
        ser_ips=(${ser_ip_str})
        IFS="$OLD_IFS"
        for ser_ip in ${ser_ips[@]}
        do
            ssh -o StrictHostKeyChecking=no ${ser_ip} "${INSTALL_ROOT}/manager/agent/bin/ipmc_adm -cmd restartapp -app ${ser_name}"
            if [[ "$?" != "0" ]]
            then
                LOG "ERROR" "restart ${ser_name} failed in ip ${ser_ip}"
                return 1
            fi
            LOG "INFO" "restart ${ser_name} success in ip ${ser_ip}"
        done
    done

    # 检查重启结果
    restart_success="success"
    for service_and_ip in ${service_and_ips[@]}
    do
        OLD_IFS="$IFS"
        IFS="|"
        s_ips=(${service_and_ip})
        IFS="$OLD_IFS"
        ser_name=${s_ips[0]}
        ser_ip_str=${s_ips[1]}
        IFS=","
        ser_ips=(${ser_ip_str})
        IFS="$OLD_IFS"
        for ser_ip in ${ser_ips[@]}
        do
            i=0
            times=3
            while [ $i -lt $times ]
            do
                ipmc_adm -cmd statusapp -app ${ser_name} -nodeip ${ser_ip} | egrep -v 'No matched processes|All Processes|Process Name|^$' | grep 'RUNNING'
                if [[ "$?" == "0" ]]
                then
                    LOG "INFO" "Service ${ser_name} has been started on node ${ser_ip}"
                    break
                fi
                sleep 30
                i=`expr $i + 1`
            done
            if [ $i -eq $times ]
            then
                LOG "INFO" "Microservice ${ser_name} is not started within the timeout interval"
                restart_success="fail"
            fi
        done
    done
    if [[ ${restart_success} == "fail" ]]
    then
        return 1
    fi
    LOG "INFO" "restart app end"
    return 0
}

main()
{
    LOG "INFO" "exec file ${SELF_FILE}"
    LOG "INFO" "$*"
    init_param $*
    local product_name=$(ls /opt/oss/manager/var/tenants/ | grep -v manager | grep Insight)
    local plandata_json="${INPUT_PATH}/plandata.json"
    local product_json="${INPUT_PATH}/product_${product_name}.json"
    . /opt/oss/manager/bin/engr_profile.sh
    python -c """
import json
import os
with open('${plandata_json}', 'r', encoding='utf-8') as p_stream:
    plan_data = json.load(p_stream)
    src_version = plan_data.get('src_version')
with open('${product_json}', 'r', encoding='utf-8') as r_stream:
    product_data = json.load(r_stream)
    product_data.get('productext').update({'product_version': src_version})
with os.fdopen(os.open('${product_json}', os.O_CREAT | os.O_WRONLY | os.O_TRUNC, mode=0o600), 'w') as w_stream:
    w_stream.write(json.dumps(product_data))
"""
    sh /opt/oss/manager/tools/resmgr/modifyproductinfo.sh -input ${product_json}
    if [[ "$?" != "0" ]];then
        LOG "ERROR" "modify product version failed"
        return 1
    fi
    ipmc_adm -cmd stopnodes -tenant CampusInsight -type app
    if [[ "$?" != "0" ]];then
        LOG "ERROR" "stopnodes failed"
        return 1
    fi
    LOG "INFO" "exec file ${SELF_FILE} end"
    return 0
}

main $*
exit $?