#!/bin/bash
#get absolute path 
FileName="`basename $0`"
RELATIVE_PATH="$(dirname $0)"
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`

MODULE_NAME="`basename $0 | sed 's/\.sh$//'`"
#import common variable..
. ./common.inc
cd - &> /dev/null


function fn_check_params()
{
    local oldinstall_path=$1
    local newsudobin_path=$2
    
    PRINT_LOG "INFO" "Start to check input params."
    
    if [ -z "${oldinstall_path}" ]
    then
        PRINT_LOG "FATAL" "The install path is empty."
        return 3
    fi
    
    if [ ! -d "${newsudobin_path}" ]
    then
        PRINT_LOG "FATAL" "The sudobin path ${newsudobin_path} is not exist."
        return 3
    fi
    
    PRINT_LOG "INFO" "Check input params done."
    return 0
}

function fn_permission_control()
{
    cd "${ABSOLUATELY_PATH}" &>/dev/null
    
    chmod 640 *.zip *.tar logs/*.log package/* &> /dev/null
    chmod 600 *.cms *.crl &> /dev/null
    chmod 750 logs package logs/tmp &> /dev/null
    chmod 550 *.sh &> /dev/null
    
    cd - &>/dev/null
}

function fn_upgrade()
{
    PRINT_LOG "INFO" "Start to upgrade osconfig."
    local oldinstall_path=$1
    local newsudobin_path=$2
    local isolation_flag="$3"
    
    #Note: not install osconfig before
    if [ -d "${oldinstall_path}" ]
    then
        PRINT_LOG "INFO" "The osconfig install path exist, need to uninstall old osconfig."
        #Note: uninstall osconfig
        PRINT_LOG "INFO" "Start to uninstall osconfig." &>/dev/null

        chmod 750 ${oldinstall_path}/os/bin &> /dev/null
        if [ -f "${oldinstall_path}/os/bin/uninstall.sh" ]
        then
            fn_disabl_features "${oldinstall_path}"
            bash ${oldinstall_path}/os/bin/uninstall.sh "upgrade" &> ${TMP_CONTENT_FILE}
            if [ $? -ne 0 ]
            then
                PRINT_LOG "WARN" "Exec<${oldinstall_path}/os/bin/uninstall.sh upgrade> failed."
                ls ${oldinstall_path} | grep -vw logs | xargs -I {} rm -rf ${oldinstall_path}/{} >> "${TMP_CONTENT_FILE}" 2>&1
                if [ $? -ne 0 ]
                then
                    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
                    PRINT_LOG "WARN" "Execute osconfig uninstall failed."
                fi
            fi
        else
            PRINT_LOG "WARN" "uninstall.sh script is not exist." &>/dev/null
            ls ${oldinstall_path} | grep -vw logs | xargs -I {} rm -rf ${oldinstall_path}/{} &> /dev/null
        fi
        
        PRINT_LOG "INFO" "Uninstall osconfig success."
    fi

    fn_clean_old_register

    PRINT_LOG "INFO" "Start to install osconfig."
    bash "${ABSOLUATELY_PATH}/install.sh" -sudobinpath "${newsudobin_path}" &> "${TMP_CONTENT_FILE}"
    if [ $? -ne 0 ]
    then
        fn_permission_control
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}"
        PRINT_LOG "FATAL" "Execute osconfig install failed."
        return 1
    fi
    
    local sudo_pkg="${ABSOLUATELY_PATH}/sudobin_pkg.tar"
    local sudo_tmpPath="/tmp/osconfig_${RANDOM}"

    if [ ! -z "${isolation_flag}" ]
    then
        sudo "${newsudobin_path}/execute.sh" "${sudo_pkg}" "${sudo_tmpPath}" "upgrade.sh" "upgrade" "${isolation_flag}" &> "${TMP_CONTENT_FILE}"
        local ret_code=$?
        PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
        if [ $ret_code -ne 0 ]
        then
            PRINT_LOG "FATAL" "Exec the cmd <sudo '${newsudobin_path}/execute.sh' '${sudo_pkg}' '${sudo_tmpPath}' 'upgrade.sh' 'upgrade' '${isolation_flag}'> failure, backup os_tool failed."
            return 1
        fi
    fi

    fn_permission_control
    PRINT_LOG "INFO" "Install osconfig success"

    PRINT_LOG "INFO" "Upgrade osconfig done."
    return 0
}


function fn_get_opt()
{
    while [ $# -gt 0 ]
    do
        [ "$1" = "-oldinstallpath" ] && oldinstall_path="$2"
        [ "$1" = '-newinstallpath' ] && newinstall_path="$2"
        [ "$1" = '-newsudobin' ] && newsudobin_path="$2"
        [ "$1" = '-userisolation' ] && isolation_flag="$2"
        shift
        shift
    done

    return 0
}

#*************************************************************#
# Name:         fn_main                                       #
# Description:  main function                                 #
# Parameters:   NULL                                          #
#*************************************************************#
function fn_main()
{
    PRINT_LOG "INFO" "bash osconfig_upgrade.sh $*" &>/dev/null
    
    if [ $# -lt 6 ]
    then
        PRINT_LOG "FATAL" "Usage: osconfig_upgrade.sh -oldinstallpath <path> -newinstallpath <path> -newsudobin <path>"
        return 3
    fi

    fn_get_opt $@ 
    if [ -z "${oldinstall_path}"  -o  -z "${newinstall_path}"  -o  -z "${newsudobin_path}" ]
    then
        PRINT_LOG "FATAL" "Usage: osconfig_upgrade.sh -oldinstallpath <path> -newinstallpath <path> -newsudobin <path>"
        return 3
    fi

    if [[ ! "${isolation_flag}" =~ ^[Tt][Rr][Uu][Ee]$ && ! "${isolation_flag}" =~ ^[Ff][Aa][Ll][Ss][Ee]$ && ! -z "${isolation_flag}" ]]
    then
        PRINT_LOG "FATAL" "Usage: osconfig_upgrade.sh -oldinstallpath <path> -newinstallpath <path> -newsudobin <path> [-userisolation <true|false>]"
        return 3
    fi
    
    PRINT_LOG "INFO" "oldinstall_path:<${oldinstall_path}>, newinstall_path:<${newinstall_path}>, newsudobin_path:<${newsudobin_path}>."
    fn_check_env || return $?

    fn_check_params "${oldinstall_path}" "${newsudobin_path}" || return $?


    fn_upgrade "${oldinstall_path}" "${newsudobin_path}" "${isolation_flag}" || return $?
    
    return 0
}

function fn_clean_old_register()
{
    rm -rf /usr/local/osconfig/etc/manifest
    rm -rf /usr/local/osconfig/etc/uds
}

fn_main "$@"
RET_MAIN=$?
if [[ "$RET_MAIN" == "0" ]]
then
    logger -t $USER -p local0.info "$FileName;Successful;${OPERIP:-127.0.0.1};Excute execution $FileName to upgrade osconfig."
else
    ERROR_CODE=$(echo ${ERROR_CODE} | xargs -n1 | sort -u | xargs)
    [ ! -z "${ERROR_CODE}" ] && PRINT_LOG "INFO" "Error code: ${ERROR_CODE}"
    logger -t $USER -p local0.err "$FileName;Failed;${OPERIP:-127.0.0.1};Excute execution $FileName to upgrade osconfig."
fi
[ -f "${TMP_CONTENT_FILE}" ] && rm -f "${TMP_CONTENT_FILE}" &> /dev/null
FUNC_CLEAN_TMP_FILE &> /dev/null
exit ${RET_MAIN}