#!/bin/bash
#================
# FILE          : config_os.sh
#----------------
# PROJECT       :
# COPYRIGHT     : cloud-sop
#               :
# AUTHOR        :
#               :
# BELONGS TO    : OSMgr-osconfig
#               :
# DESCRIPTION   : config os interface
#               :
# STATUS        : Development
#----------------
#======================================
# usage:
#           sh config_os.sh -output /tmp/output.json
# input:
#           NULL
# output:
#           0:success
#           not 0:failed
#--------------------------------------

#======================================
# Return code
#--------------------------------------
RET_SUCCESS=0
RET_INVALID_PARA=1
RET_FILE_NOT_EXIST=2
RET_EXEC_FAILURE=3

SCRIPT_NAME="`basename $0`"
MODULE_NAME="`echo ${SCRIPT_NAME} | sed 's/\.sh//g'`"
RELATIVE_PATH="`dirname $0`"
TMP_FOLDER=""

cd "${RELATIVE_PATH}"
ABSOLUTELY_PATH=`pwd`
#Note: import common variable..
. ${ABSOLUTELY_PATH}/../bin/engr_profile.sh
cd - >/dev/null 2>&1

INPUT_FILE=""
[ -z "${WORK_USER}" ] && WORK_USER='ossadm'

function fn_check_folder_mode()
{
    local folder="$1"
    local mode=$(stat -c %A "${folder}")
    local owner_mode=$(stat -c %U:%G ${folder})

    if [ "${folder}" = "/tmp" ] && [ "${owner_mode}" = "root:root" ]
    then
        return 0
    fi

    if [ "${owner_mode}" = "${WORK_USER}:ossgroup" ]
    then
        return 0
    fi

    PRINT_LOG "FATAL" "The folder mode is invalid."
    return 1
}

function fn_check_file_mode()
{
    local file="$1"
    local owner_mode=$(stat -c %U:%G ${file})
    if [ "${owner_mode}" = "${WORK_USER}:ossgroup" ]
    then
        return 0
    fi
    PRINT_LOG "FATAL" "The file mode is invalid."
    return 1
}

function fn_check_file_link()
{
    local file="$1"
    if [ -z "${file}"  -o ! -f "${file}" ]
    then
        PRINT_LOG "FATAL" "The parameter \"${file}\" is invalid."
        return 2
    fi
    local softlink=`ls -l "${file}" |cut -c1`
    local hardlink="`stat -c %h ${file}`"
    if [[ "${softlink}" == "l" || ${hardlink} -ne 1 ]]
    then
        PRINT_LOG "FATAL" "The file: <${file}> is a softlink file or hardlink file"
        return 3
    fi
    local abs_path=`readlink -m "${file}"`
    local file_path=`echo "${file}" | sed -r -e 's#/+#/#g' -e 's#/$##'`
    if [ "${abs_path}" != "${file_path}" ]
    then
        PRINT_LOG "FATAL" "The file: <${file}> invalid."
        return 5
    fi
    return 0
}

function fn_main()
{
    if [ $# -ne 4 -a $# -ne 5 -a $# -ne 6 ]
    then
        PRINT_LOG "FATAL" "Usage: bash ${SCRIPT_NAME} <harden|unharden|check|config> /tmp/output.json [/tmp/input.json] [action_type]"
        return ${RET_INVALID_PARA}
    fi

    if [ "${1}" != "harden" -a "${1}" != "unharden" -a "${1}" != "check" -a "${1}" != "config" ]
    then
        PRINT_LOG "FATAL" "Usage: bash ${SCRIPT_NAME} <harden|unharden|check|config> /tmp/output.json [/tmp/input.json] [action_type]"
        return ${RET_INVALID_PARA}
    fi

    ACTION_TYPE="$1"
    RESULT_FILE="$2"
    OS_TYPE="$3"
    INPUT_FILE="$4"
    EXEC_TYPE="$5"

    if [ -n "${EXEC_TYPE}" ] && [[ ! "${EXEC_TYPE}" =~ ^[a-zA-Z]+$ ]]
    then
        PRINT_LOG "FATAL" "The ${EXEC_TYPE} is invalid, the action_type only contain the chars [a-zA-Z]."
        return 1
    fi

    if [ ! -f "${RESULT_FILE}" ]
    then
        PRINT_LOG "FATAL" "The result file <${RESULT_FILE}> must be exist."
        return ${RET_INVALID_PARA}
    fi

    TMP_FOLDER="/tmp/result_$$_${RANDOM_INFO}"
    mkdir -m 755 "${TMP_FOLDER}" || return $?

    TMP_RESULT_FILE="${TMP_FOLDER}/result_$$_${RANDOM_INFO}.json"

    local go_file="${ABSOLUTELY_PATH}/ostool"
    if [ ! -f "${go_file}" ]
    then
        PRINT_LOG "FATAL" "The go binary execute file <${go_file}> does not exist."
        return ${RET_FILE_NOT_EXIST}
    fi

    if [ -z "${INPUT_FILE}" ]
    then
        ${go_file} "-action" "${ACTION_TYPE}" "-output" "${TMP_RESULT_FILE}" "-rootpath" "${CURRENT_WORK_PATH}" "-osType" "${OS_TYPE}" "-action_type" "${EXEC_TYPE}"&> "${TMP_CONTENT_FILE}"
    else
        ${go_file} "-action" "${ACTION_TYPE}" "-output" "${TMP_RESULT_FILE}" "-rootpath" "${CURRENT_WORK_PATH}" "-osType" "${OS_TYPE}" "-input" "${INPUT_FILE}" "-action_type" "${EXEC_TYPE}" &> "${TMP_CONTENT_FILE}"
    fi

    local retCode=$?
    PRINT_FILE_TO_LOG "${TMP_CONTENT_FILE}" &> /dev/null
    if [ -f "${TMP_RESULT_FILE}" ]
    then
        fn_check_file_link "${TMP_RESULT_FILE}" || return $?
        chmod 500 "${TMP_RESULT_FILE}" || return $?
        chown "${WORK_USER}":ossgroup "${TMP_RESULT_FILE}" || return $?
        fn_check_file_link "${RESULT_FILE}" || return $?
        fn_check_folder_mode "${RESULT_FILE}" || return $?
        su - "${WORK_USER}" -c "cp -f ${TMP_RESULT_FILE} ${RESULT_FILE}"
    fi

    if [ ${retCode} -ne 0 ]
    then
        PRINT_LOG "FATAL" "The ${ACTION_TYPE} OS action execute failed, retcode=${retCode}."
        return ${RET_EXEC_FAILURE}
    fi

    return ${RET_SUCCESS}
}


PRINT_LOG "INFO" "########################################################" &> /dev/null
PRINT_LOG "INFO" "bash ${ABSOLUTELY_PATH}/${SCRIPT_NAME} $@" &> /dev/null
fn_main "$@"
RET_MAIN=$?
PRINT_LOG "INFO" "The result: ret=${RET_MAIN}" &> /dev/null
FUNC_CLEAN_TMP_FILE &> /dev/null
[ -d "${TMP_FOLDER}" ] && rm -rf "${TMP_FOLDER}"
exit ${RET_MAIN}