#!/bin/bash
set +x

. /etc/profile > /dev/null 2>&1
. /opt/arbitration_file/env.properties
TMOUT=0

rootDir=$(echo $(cd "$(dirname "$0")"; pwd))

function add_account()
{
    echo "begin to add the arbiter account ..."
    bash /opt/arbitration_file/user_util.sh
    return $?
}

function cron_hwclock()
{
    echo "begin to config hwclock cron task ..."


    sed -i -e '/hwclock/d' /etc/crontab
    # The value must be the same as that configured in the ICMR.
    echo "*/1 * * * * root hwclock --systohc > /dev/null 2>&1" >> /etc/crontab
    if [ $? -ne 0 ]
    then
        echo "config hwclock cron task failed."
        return 1
    fi

    return 0
}

function setup_jre()
{
    echo "begin to setup Java Runtime Environment ..."
    #jre name jre-2.2.5.zip,create dir /opt/arbitration-common/foss/jre-2.2.5
    local foss_path=$rootDir/../foss
    unzip /opt/arbitration_file/EnvJRE*.zip -d ${foss_path}/temp_envjre > /dev/null

    local jre_zip_name=$(find ${foss_path}/temp_envjre -name jre*.zip)
    local java_home="${foss_path}/java/jre"
    mkdir -p ${java_home}
    [[ -e "${jre_zip_name}" ]] && unzip "${jre_zip_name}" -d ${java_home}  > /dev/null
    if [ $? -ne 0 ]
    then
        echo "extract jre package failed."
        return 1
    fi
    rm -rf "${foss_path}/temp_envjre"

    sed -i '/ARBITRATION_JAVA_HOME=/d' /opt/arbitration_file/env.properties
    local jre_home_abs=$(echo $(cd "${java_home}";pwd))
    echo "export ARBITRATION_JAVA_HOME=${jre_home_abs}" >> /opt/arbitration_file/env.properties

    chmod 550 "${rootDir}/../foss/java" -R
    find "$rootDir/../foss/java" -name "*.gif" -o -name "*.jpg" -o -name "*.png" -o -name "*.bmp" -o -name "*.pic" -o -name "*.tif" -o -name "*.svg" -o -name "*.html" -o -name "*.htm" -o -name "*.pyc" -o -name "*.so" -o -name "*.css" -o -name "*.js" -o -name "*.jsp" -o -name "*.sql" -o -name "*.jar" -o -name "*.class" | xargs chmod 440 >/dev/null 2>&1
    find "$rootDir/../foss/java" -name "*.pc" | xargs chmod 440 >/dev/null 2>&1
    chown arbiter:ArbiterGroup "${rootDir}/../foss/java" -R
    return 0
}

function setup_python()
{
    echo "begin to setup python environment ..."
    # python package name python.zip

    mkdir -p "${rootDir}/../foss/python"

    local arbitration_temp_path=/opt/arbitration_file/arbitration_temp
    bash /opt/arbitration_file/get_arbitration_python.sh ${arbitration_temp_path} > /dev/null
    if [ $? -ne 0 ]
    then
        echo "extract python package failed."
        return 1
    fi

    cp -rf ${arbitration_temp_path}/arbitration_python/* $rootDir/../foss/python/
    chmod 550 $rootDir/../foss/python -R
    find "$rootDir/../foss/python" -name "*.gif" -o -name "*.jpg" -o -name "*.png" -o -name "*.bmp" -o -name "*.pic" -o -name "*.tif" -o -name "*.svg" -o -name "*.html" -o -name "*.htm" -o -name "*.pyc" -o -name "*.so" -o -name "*.css" -o -name "*.js" -o -name "*.jsp" -o -name "*.sql" -o -name "*.jar" -o -name "*.class" | xargs chmod 440 >/dev/null 2>&1
    find "$rootDir/../foss/python" -name "*.pc" | xargs chmod 440 >/dev/null 2>&1
    
    chown arbiter:ArbiterGroup $rootDir/../foss/python -R
    return 0
}

function main()
{
    add_account
    if [ $? -ne 0 ]
    then
        return 1
    fi

    cron_hwclock
    if [ $? -ne 0 ]
    then
        return 1
    fi

    setup_jre
    if [ $? -ne 0 ]
    then
        return 1
    fi

    setup_python
    if [ $? -ne 0 ]
    then
        echo "set python environment failed."
        return 1
    fi
    
    #for alarm agent service and log
    chown arbiter: ${COMMON_HOME}/script/
    chown arbiter: ${COMMON_HOME}
    mkdir -p ${COMMON_LOG}
    chmod 750 ${COMMON_LOG}
    chown arbiter: ${COMMON_LOG} -R
    
    echo "execute setup-all.sh success."
    return 0
}

main
exit $?
