#!/bin/bash

###########################
# 修正仲裁节点NTP时间配置
###########################
function config_third_ntp()
{
    cat /etc/ntp.conf | grep "^server 127.127.1.0 prefer"
    if [ $? -eq 0 ]
    then
        sed -i 's/server 127.127.1.0 prefer//g' /etc/ntp.conf
    fi
    
    # 检查是否有除自己的主时钟源
    cat /etc/ntp.conf | grep "^server" | grep -v "127.127.1.0" | grep "prefer"
    if [ $? -eq 0 ]
    then
        # 检查主时钟源是否有配置true
        cat /etc/ntp.conf | grep "^server" | grep -v "127.127.1.0" | grep "prefer" | head -n 1 | grep "true$"
        if [ $? -ne 0 ]
        then
            master_ntp_config=$(cat /etc/ntp.conf | grep "^server" | grep -v "127.127.1.0" | grep "prefer" | head -n 1)
            sed -i "s/${master_ntp_config}/${master_ntp_config} true/g" /etc/ntp.conf
        fi
    fi
    
    systemctl restart ntpd.service
    
    systemctl status ntpd.service | grep "active" | grep "running"
    if [ $? -ne 0 ]
    then
        systemctl restart ntpd.service
    fi
}

###########################
# 主入口
###########################
function main()
{
    config_third_ntp
}

main $@ >/dev/null 2>&1
exit $?