#!/bin/bash
echo "SMPAgentService script execut start"
# 所有结果保存在route_ipv4的集合中
route_ipv4=()
route_static_ipv4=()
route_ipv6=()

function mask_mapper()
{
    mask="$1"
    case "$mask" in
        32)
        echo "255.255.255.255"
        ;;
        24)
        echo "255.255.255.0"
        ;;
        16)
        echo "255.255.0.0"
        ;;
        8)
        echo "255.0.0.0"
        ;;
        0)
        echo "0.0.0.0"
        ;;
    esac
}

function get_route_ipv4()
{
    IFS=$'\n'
    for line in `netstat -nr |grep -v "lo$" |sed -n '3,$p'`
    do 
        l2=$(echo "$line" |awk '{print $2}')
        if [ ! "$l2" == "0.0.0.0" ]; then 
                 dest=$(echo "$line" |awk '{print $1}')
                 gateway=$(echo "$line" |awk '{print $2}')
                 mask=$(echo "$line" |awk '{print $3}')
                     route_ipv4=(${route_ipv4[@]} "cmd_route$dest,$gateway")
        fi
    done
}

function get_route_ipv6()
{
    IFS=$'\n'
    for line in `netstat -6 -nr | grep -v -E 'Destination|Kernel|lo$'`
    do 
        l2=$(echo "$line" |awk '{print $2}')
        if [ ! "$l2" == "::" ]; then 
                 dest=$(echo "$line" |awk '{print $1}')
                 gateway=$(echo "$line" |awk '{print $2}')
                     route_ipv4=(${route_ipv4[@]} "cmd_route$dest,$gateway")
        fi
    done
}

# 1. network
function get_route_from_network()
{
    IFS=$'\n'
    if [ -f "/etc/sysconfig/network" ]; then
        gateway=$(cat /etc/sysconfig/network |grep -v "#" | grep "GATEWAY" |awk -F"=" '{print $2}' |sed "s/'//g"| tr -d '\r')
        if [ ! -z "$gateway" ]; then
        
            route_static_ipv4=(${route_static_ipv4[@]} "config_route0.0.0.0,$gateway,0.0.0.0")
        fi
    fi
}

function get_route_from_network_ipv6()
{
    IFS=$'\n'
    if [ -f "/etc/sysconfig/network" ]; then
        gateway=$(cat /etc/sysconfig/network |grep -v "#" | grep "GATEWAY" |awk -F"=" '{print $2}' |sed "s/'//g"| tr -d '\r')
        if [ ! -z "$gateway" ]; then
           
            ## 如果是ipv6  
            route_static_ipv4=(${route_static_ipv4[@]} "config_route::1,$gateway")
        fi
    fi
}

# 2. static-route  any net 0.0.0.0 netmask 255.255.255.0 gw 127.0.0.1
function get_route_from_static()
{    
    IFS=$'\n'
    if [ -f "/etc/sysconfig/static-routes" ]; then    
        for line in `cat /etc/sysconfig/static-routes |grep -v "#" |grep " gw "`
        do
            gateway=$(echo "$line" |awk -F"gw" '{print $NF}' |sed "s/ //g"| tr -d '\r')
            destination=$(echo "$line" |awk -F" " '{print $3}' |sed "s/ //g"| tr -d '\r')
            mask=$(echo "$line" |awk -F" " '{print $5}' |sed "s/ //g"| tr -d '\r')
            route_static_ipv4=(${route_static_ipv4[@]} "config_route$destination,$gateway,$mask")
        done
       
    fi
}

# 3. route-*
function get_route_from_route()
{
    IFS=$'\n'
    for filename in `ls /etc/sysconfig/network-scripts/ | grep ^route-*`
    do
        if [ "$filename" == "route-lo" ]; then
            continue
        fi    
        if [[ "$filename" =~ ^route- ]]
        then
            rf="/etc/sysconfig/network-scripts/$filename"
            for addr in `cat "$rf" |grep -v "#" | grep ADDRESS`
            do
                dest=$(echo "$addr" |awk -F"=" '{print $2}' |sed "s/'//g "|sed 's/"//g'| tr -d '\r'|grep -v "#" )
                id=$(echo "$addr" |awk -F"=" '{print $1}' |sed 's/ADDRESS//g' | tr -d '\r'|grep -v "#" )
                mask=$(cat "$rf" |grep "NETMASK$id=" |grep -v "#" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g' | tr -d '\r' )
                gateway=$(cat "$rf" |grep "GATEWAY$id=" |grep -v "#" |awk -F"=" '{print $2}' |sed "s/'//g"|sed 's/"//g' | tr -d '\r' )
                route_static_ipv4=(${route_static_ipv4[@]} "config_psint$dest,$gateway,$mask")
            done
        fi
    done    
}

# 4. ifcfg-*
function get_route_from_ifcfg()
{
    IFS=$'\n'
    for rf in `ls /etc/sysconfig/network-scripts/ifcfg-*`
    do
        if [ "$rf" == "/etc/sysconfig/network-scripts/ifcfg-lo" ]; then
            continue
        fi 
        
        dhcp=$(cat "$rf" |grep -v "#" |grep "BOOTPROTO" |awk -F"=" '{print $2}' |sed "s/'//g"  |sed 's/"//g'  | tr -d '\r')
        if [ "$dhcp" == "dhcp" ]; then
            echo "config_no_running"
            echo "SMPAgentService script execut end"
            exit;
        fi
        
        gateway=$(cat "$rf" |grep -v "#" |grep "GATEWAY")
        if [ -z "$gateway" ]; then
            continue
        fi

        gateway=$(echo "$gateway" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        if [ -z "$gateway" ]; then
            continue
        fi

        dest=$(cat "$rf" |grep -v "#" |grep "IPADDR" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        mask=$(cat "$rf" |grep -v "#" |grep "NETMASK" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        route_static_ipv4=(${route_static_ipv4[@]} "config_psint$dest,$gateway,$mask")

    done
}

# 5. ifcfg-* 适配新的ipv4默认路由 0.0.0.0
function get_route_from_ipv4_ifcfg()
{
    IFS=$'\n'
    for rf in `ls /etc/sysconfig/network-scripts/ifcfg-*`
    do
        if [ "$rf" == "/etc/sysconfig/network-scripts/ifcfg-lo" ]; then
            continue
        fi 
        
        dhcp=$(cat "$rf" |grep -v "#" |grep "BOOTPROTO" |awk -F"=" '{print $2}' |sed "s/'//g"  |sed 's/"//g'  | tr -d '\r')
        if [ "$dhcp" == "dhcp" ]; then
            echo "config_no_running"
            echo "SMPAgentService script execut end"
            exit;
        fi
        
        gateway=$(cat "$rf" |grep -v "#" |grep "GATEWAY")
        if [ -z "$gateway" ]; then
            continue
        fi

        gateway=$(echo "$gateway" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        if [ -z "$gateway" ]; then
            continue
        fi

        
        mask=$(cat "$rf" |grep -v "#" |grep "NETMASK" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        route_static_ipv4=(${route_static_ipv4[@]} "config_route0.0.0.0,$gateway,$mask")

    done
}

# 6. ifcfg-* ipv6环境监测
function get_route_from_ifcfg_ipv6()
{
    IFS=$'\n'
    for rf in `ls /etc/sysconfig/network-scripts/ifcfg-*`
    do
        if [ "$rf" == "/etc/sysconfig/network-scripts/ifcfg-lo" ]; then
            continue
        fi

        gateway=$(cat "$rf" |grep -v "#" |grep "IPV6DEFAULTGW=")
        if [ -z "$gateway" ]; then
            continue
        fi

        gateway=$(echo "$gateway" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        if [ -z "$gateway" ]; then
            continue
        fi

        dest=$(cat "$rf" |grep -v "#" |grep "IPV6ADDR=" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        mask=$(cat "$rf" |grep -v "#" |grep "IPV6PREFIX=" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        route_static_ipv4=(${route_static_ipv4[@]} "config_psint$dest,$gateway,$mask")
    done
}

# 7. ifcfg-* ipv6环境监测 添加新的适配字段 适配默认路由 IPV6_DEFAULTGW=
function get_route_from_ifcfg_new_ipv6()
{
    IFS=$'\n'
    for rf in `ls /etc/sysconfig/network-scripts/ifcfg-*`
    do
        if [ "$rf" == "/etc/sysconfig/network-scripts/ifcfg-lo" ]; then
            continue
        fi

        gateway=$(cat "$rf" |grep -v "#" |grep "IPV6_DEFAULTGW=")
        if [ -z "$gateway" ]; then
            continue
        fi

        gateway=$(echo "$gateway" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        if [ -z "$gateway" ]; then
            continue
        fi

        dest=$(cat "$rf" |grep -v "#" |grep "IPV6ADDR=" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        mask=$(cat "$rf" |grep -v "#" |grep "IPV6PREFIX=" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        route_static_ipv4=(${route_static_ipv4[@]} "config_route::,$gateway,$mask")
        route_static_ipv4=(${route_static_ipv4[@]} "config_route::1,$gateway,$mask")
    done
}

# 9. ifcfg-* ipv6环境监测 添加新的适配字段 适配默认路由 IPV6DEFAULTGW=
function get_route_from_ifcfg_new_format_ipv6()
{
    IFS=$'\n'
    for rf in `ls /etc/sysconfig/network-scripts/ifcfg-*`
    do
        if [ "$rf" == "/etc/sysconfig/network-scripts/ifcfg-lo" ]; then
            continue
        fi

        gateway=$(cat "$rf" |grep -v "#" |grep "IPV6DEFAULTGW=")
        if [ -z "$gateway" ]; then
            continue
        fi

        gateway=$(echo "$gateway" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        if [ -z "$gateway" ]; then
            continue
        fi

        dest=$(cat "$rf" |grep -v "#" |grep "IPV6ADDR=" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        mask=$(cat "$rf" |grep -v "#" |grep "IPV6PREFIX=" |awk -F"=" '{print $2}' |sed "s/'//g" |sed 's/"//g'| tr -d '\r')
        route_static_ipv4=(${route_static_ipv4[@]} "config_route::,$gateway,$mask")
        route_static_ipv4=(${route_static_ipv4[@]} "config_route::1,$gateway,$mask")
    done
}

# 10. rc.local 
function get_route_from_rclocal()
{
    IFS=$'\n'
    if [ -f "/etc/rc.local" ]; then
        for line in `cat /etc/rc.local |grep -v "#" |grep " gw "`
        do
            if [[ "$line" =~ "inet6" ]]; then
                gateway=$(echo "$line" |awk -F"gw" '{print $2}'|awk -F" " '{print $1}'|sed "s/ //g" | tr -d '\r')                              
                ip_mask=$(echo "$line" |awk -F"gw" '{print $1}'|awk -F" " '{print $5}'|sed "s/ //g" | tr -d '\r')
                ip=$(echo "$ip_mask" |awk -F"/" '{print $1}')
                mask=$(echo "$ip_mask" |awk -F"/" '{print $2}')
                if [ ! -z "$ip" ] && [ ! -z "$mask" ]; then
                    mask=$(mask_mapper $mask) 
                    route_static_ipv4=(${route_static_ipv4[@]} "config_route$ip,$gateway,$mask")

                fi
            else
                gateway=$(echo "$line" |awk -F"gw" '{print $NF}' |sed "s/ //g" | tr -d '\r')
                ip_mask=$(echo "$line" |awk -F"gw" '{print $1}' |awk '{print $NF}' |sed "s/ //g" | tr -d '\r')
                ip=$(echo "$ip_mask" |awk -F"/" '{print $1}')
                mask=$(echo "$ip_mask" |awk -F"/" '{print $2}')
                if [ ! -z "$ip" ] && [ ! -z "$mask" ]; then
                    mask=$(mask_mapper $mask) 
                    route_static_ipv4=(${route_static_ipv4[@]} "config_route$ip,$gateway,$mask")

                fi
            fi
        done
    fi
}

# 11. /etc/sysconfig/static-routes-ipv6
 function get_route_from_static_routes_ipv6()
{
     IFS=$'\n'
      if [ -f "/etc/sysconfig/static-routes-ipv6" ]; then
        for line in `cat /etc/sysconfig/static-routes-ipv6 |grep -v "#"`
        do
            ip_tem=$(echo "$line" |awk -F" " '{print $2}')
            gateway=$(echo "$ip_tem" |awk -F"/" '{print $1}')
            mask=$(echo "$line" |awk -F" " '{print $3}')
            if [ ! -z "$gateway" ] && [ ! -z "$mask" ]; then
                    route_static_ipv4=(${route_static_ipv4[@]} "config_ipv6$gateway,$mask")
            fi
        done
    fi

}


# 12. route6-*
function get_route_from_route6_ipv6()
{
    IFS=$'\n'
    for filename in `ls /etc/sysconfig/network-scripts/ | grep ^route6-*`
    do
        if [ "$filename" == "route6-lo" ]; then
            continue
        fi    
        if [[ "$filename" =~ ^route6- ]]
        then
            rf="/etc/sysconfig/network-scripts/$filename"
            for addr in `cat "$rf" |grep -v "#"`
            do
                route_static_ipv4=(${route_static_ipv4[@]} "config_route6_ipv6$addr")
            done
        fi
    done    
}

# 13. route-*
function get_route_from_route4_ipv4()
{
    IFS=$'\n'
    for filename in `ls /etc/sysconfig/network-scripts/ | grep ^route-*`
    do
        if [ "$filename" == "route-lo" ]; then
            continue
        fi    
        if [[ "$filename" =~ ^route- ]]
        then
            rf="/etc/sysconfig/network-scripts/$filename"
            for addr in `cat "$rf" |grep -v "#"|grep -v "="`
            do
                route_static_ipv4=(${route_static_ipv4[@]} "config_route4_ipv4$addr")
            done
        fi
    done    
}


# 判断环境为ipv4 还是 ipv6
function is_ipv4_or_ipv6()
{
    ipv4_num=$(ifconfig | grep inet | wc -l)
    ipv6_num=$(ifconfig | grep inet6 | wc -l)
    if [ "$ipv6_num" == 0 ]; then
         get_route_ipv4
         get_route_from_network
         get_route_from_static
         get_route_from_route
         get_route_from_ifcfg
         get_route_from_ipv4_ifcfg
         get_route_from_rclocal
         get_route_from_route4_ipv4
    fi
    if [ "$ipv4_num" == "$ipv6_num" ]; then
        get_route_ipv6
        get_route_from_static
        get_route_from_route
        get_route_from_ifcfg_ipv6
        get_route_from_ifcfg_new_ipv6
        get_route_from_ifcfg_new_format_ipv6
        get_route_from_rclocal
        get_route_from_network_ipv6
        get_route_from_static_routes_ipv6
        get_route_from_route6_ipv6
    fi
    if [ "$ipv4_num" -gt "$ipv6_num"  ]; then
        if [ "$ipv6_num" -gt 0 ]; then
            get_route_ipv4
            get_route_ipv6
            get_route_from_network
            get_route_from_static
            get_route_from_route
            get_route_from_ifcfg
            get_route_from_ipv4_ifcfg
            get_route_from_ifcfg_ipv6
            get_route_from_ifcfg_new_ipv6
            get_route_from_ifcfg_new_format_ipv6
            get_route_from_rclocal
            get_route_from_network_ipv6
            get_route_from_static_routes_ipv6
            get_route_from_route6_ipv6
            get_route_from_route4_ipv4
        fi
    fi

}

is_ipv4_or_ipv6

for route in "${route_ipv4[@]}"
do
    echo "$route"
done

for route in "${route_static_ipv4[@]}"
do
    echo "$route"
done


echo "SMPAgentService script execut end"