#!/bin/bash
#########################################################
# Copyright © Huawei Technologies Co., Ltd. 2020-2020. All rights reserved.
# File name: remote_sync_keystore.sh
# Description: 同步密钥到所有omp节点
###########################################################
function get_params()
{
    site_role=$1
    omp_ip_address=$2
    local_ip_address=$3

    echo "es_input: master_omp_node_uname"
    read -r master_login_user_name
    echo "es_input: master_omp_node_pwd"
    read -s -r master_login_user_pwd
    echo "es_input: master_omp_node_ossadm_pwd"
    read -s -r master_ossadm_user_pwd
    echo "es_input: node_1_root_pwd"
    read -s -r master_commonservice_root_pwd

    echo "es_input: slave_omp_node_uname"
    read -r slave_login_user_name
    echo "es_input: slave_omp_node_pwd"
    read -s -r slave_login_user_pwd
    echo "es_input: slave_omp_node_ossadm_pwd"
    read -s -r slave_ossadm_user_pwd
    echo "es_input: node_3_root_pwd"
    read -s -r slave_commonservice_root_pwd

    if [ "${site_role}" = "-master" ]
    then
        login_user_name=${master_login_user_name}
        login_user_pwd=${master_login_user_pwd}
        ossadm_user_pwd=${master_ossadm_user_pwd}
        commonservice_root_pwd=${master_commonservice_root_pwd}
    else
        login_user_name=${slave_login_user_name}
        login_user_pwd=${slave_login_user_pwd}
        ossadm_user_pwd=${slave_ossadm_user_pwd}
        commonservice_root_pwd=${slave_commonservice_root_pwd}
    fi

    # 特殊字符转义
    login_user_pwd=$(echo ${login_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    ossadm_user_pwd=$(echo ${ossadm_user_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
    commonservice_root_pwd=$(echo ${commonservice_root_pwd} | sed 's/\\/\\\\/g' | sed 's/{/\\{/g' | sed 's/}/\\}/g' | sed 's/\[/\\[/g' | sed 's/\$/\\\$/g' | sed 's/`/\\`/g' | sed 's/\"/\\\"/g')
}

function get_omp_maintaince_ip()
{
    arbitration_log INFO "SYNC_KEYSTORE" "Start to get the OMP maintenance IP address."
    omp_maintaince_ip=$(cat /opt/oss/manager/var/agent/managerip.conf | grep "^managerip" | awk -F= '{print $NF}' | sed 's/,/\n/g' | sed -n '1p')
    arbitration_log INFO "SYNC_KEYSTORE" "Success to get the OMP maintenance IP address is ${omp_maintaince_ip}."
    echo ${omp_maintaince_ip}
}

function create_check_file()
{
    result_code=$1
    create_check_result_file ${result_code} "check_sync_keystore_result.sh"
}

# 登录OMP节点，执行OMP上预置的sync_keystore.sh脚本
function remote_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
set timeout 30
spawn ssh ${login_user_name}@${omp_ip_address} 
expect {
    "*yes/no*" {send "yes\r";exp_continue}
    "*assword:" {send -- "${login_user_pwd}\r"}
}

expect {
    "*${login_user_name}@*" {
                            send "su - ossadm\r"
                            expect {
                                "*yes/no*" {send "yes\r";exp_continue}
                                "*assword:" {send -- "${ossadm_user_pwd}\r"}
                                "*ossadm@*" {send "\r"}
                            }
    
                            expect {
                                "*ossadm@*" {
                                    send "bash /opt/oss/manager/apps/DRService/shscript/sync_keystore.sh ${local_ip_address} /opt/arbitration_tmp ${sha256_clientKeyStore} ${sha256_clientTrustStore}\r"
                                    expect {
                                        "please input root password:" {send -- "${commonservice_root_pwd}\r"}
                                    }
                                    
                                    expect {
                                        "*synchronize keystore failed*" { exit 255 }
                                        "*synchronize keystore successfully*" { exit 100 }
                                    }
                                }
                            }
                            
                            expect {
                                "*ossadm@*" {send "exit\r"}
                            }
    
    }
}

expect {
    "*${login_user_name}@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

ENF
    return $?
}

# 本地OMP节点，执行OMP上预置的sync_keystore.sh脚本
function local_exec()
{
    ${EXPECT} << ENF >/dev/null 2>&1
set timeout 30
spawn su - ossadm
expect {
    "*ossadm@*" {
        send "bash /opt/oss/manager/apps/DRService/shscript/sync_keystore.sh ${local_ip_address} /opt/arbitration_tmp ${sha256_clientKeyStore} ${sha256_clientTrustStore}\r"
        expect {
            "please input root password:" {send -- "${commonservice_root_pwd}\r"}
        }

        expect {
            "*synchronize keystore failed*" { exit 255 }
            "*synchronize keystore successfully*" { exit 100 }
        }
    }
}

expect {
    "*ossadm@*" {send "exit\r"}
}

expect timeout { exit 1 }
expect eof

catch wait result
exit [lindex $result 3]

ENF
    return $?
}

function omp_exec() {
    ip addr | grep -w ${omp_ip_address} >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        arbitration_log INFO "SYNC_KEYSTORE" "omp exec on local."
        local_exec
    else
        arbitration_log INFO "SYNC_KEYSTORE" "omp exec on remote."
        remote_exec
    fi
    sync_result=$?
}

function copy_keystore()
{
    [ -d "/opt/arbitration_tmp" ] && rm -rf /opt/arbitration_tmp
    mkdir -p /opt/arbitration_tmp

    # 获取文件的sha256校验码，scp后需要校验
    sha256_clientKeyStore=$(sha256sum ${src_keystore_path}/clientKeyStore.keystore | awk '{print $1}')
    sha256_clientTrustStore=$(sha256sum ${src_keystore_path}/clientTrustStore.keystore | awk '{print $1}')

    # 拷贝keystore
    cp -f ${src_keystore_path}/clientKeyStore.keystore /opt/arbitration_tmp
    cp -f ${src_keystore_path}/clientTrustStore.keystore /opt/arbitration_tmp
    
    # 控制属组和权限
    chown -R ossadm:ossgroup /opt/arbitration_tmp
    chmod 600 /opt/arbitration_tmp/*
}

function main()
{
    . ./arbitration_opertate_lib
    . ./env.properties
    . ./public.sh
    EXPECT=expect

    rm -rf /opt/arbitration_file/check_sync_keystore_result.sh

    # 获取参数
    get_params "$@"

    # 根据用户输入的omp节点IP获取maintaince IP
    omp_ip_address=$(get_omp_maintaince_ip)

    src_keystore_path="${MONITOR_HOME}/keystore"
    dst_keystore_path="/opt/oss/share/manager/DRService/ssl/etcd_ssl/client/"

    # 复制keystore并刷成ossadm属组，方便OMP节点拷贝
    copy_keystore

    # 执行脚本将keystore拷贝到OMP
    omp_exec
    if [ ${sync_result} -ne 100 ]
    then
        arbitration_log ERROR "SYNC_KEYSTORE" "Synchronize keystore failed."
        # 重试一次
        omp_exec
        if [ ${sync_result} -ne 100 ]
        then
            arbitration_log ERROR "SYNC_KEYSTORE" "Synchronize keystore failed again."
            [ -d "/opt/arbitration_tmp" ] && rm -rf /opt/arbitration_tmp
            $(create_check_file 255)
            exit
        fi

    fi

    arbitration_log INFO "SYNC_KEYSTORE" "Synchronize keystore successfully."
    [ -d "/opt/arbitration_tmp" ] && rm -rf /opt/arbitration_tmp
    $(create_check_file 100)
}

main "$@"




