#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_node_network_segment
# Description : node cannot has the sub segment on different network port.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_node_network_segment()
{
    #the variable count the fail time of check step
    typeset -i error_fail_num=0

    cd /root/EasySuite/888/script/
    res_has_sub_segment=$(/root/EasySuite/888/script/python/bin/python launch.pyc processor -i -exec pre.install.check_items -check_item "install.check_node_network_segment")
    if [[ $? == 0 ]]
    then
        echo " "
        echo "-----------------------------------------------------"
        echo "[successfully]The network segments of different network ports do not overlap."
        echo "-----------------------------------------------------"
        echo " "
    else
        echo " "
        echo "-----------------------------------------------------"
        echo "[failed]The network segments of different network ports overlap."
        IFS=$'@'
        echo ${res_has_sub_segment}
        echo "-----------------------------------------------------"
        echo " "
		echo " " >&2
        ((error_fail_num=error_fail_num+1))
    fi

    if [ ${error_fail_num} -gt 0 ]
    then
        return 1
		#failed
    else
        return 0
    fi
}
