#!/bin/bash
. ./controller.inc
################################################################################
# Function    : check_disk_io
# Description : check the disk_io.
# parameter list:null
# Output      : None
# Return      : 0 success
#               1 failed
################################################################################
function check_disk_io
{
    if [ "X${disk_io}" == "X" ];then
	    print_log "WARNING" "Expected disk IO to be checked is not configured,skip check disk IO."
        return 0
    fi
    local opt_free_size_GB=`df -h | grep opt | awk '{print $2}'`
    local opt_free_size=`fn_get_size_GB ${opt_free_size_GB}`
    if [[ `echo "${opt_free_size} < 3" | bc` -eq 1 ]];then
	    print_log "ERROR" "Disk IO check need at least 3 GB free space in /opt directory! The available space is ${opt_free_size}."
        return 1
    fi
    dd if=/dev/zero of=/opt/disk_io_test.file count=2M bs=1024 2>>/opt/disk_io_error.txt && dd if=/opt/disk_io_test.file of=/dev/null bs=1024 count=2M 2>>/opt/disk_io_error.txt
    if [ $? -eq 0 ]; then
        print_log "INFO" "get iops successfully." 
    else
	    print_log "ERROR" "get iops fail."
	    print_log "ERROR" "please check free space of /opt is or not is enough. "      
        return 1
    fi
    #获取磁盘写的时间
    write_time=`sed -n "3p" /opt/disk_io_error.txt | egrep -o '[0-9.]+ s' | awk '{print $1}'`
    #获取磁盘读的时间
    read_time=`sed -n "6p" /opt/disk_io_error.txt | egrep -o '[0-9.]+ s' | awk '{print $1}'`
    #删除文件
    rm -f /opt/disk_io_test.file
    if [ $? -eq 0 ]; then
	    print_log "INFO" "remove IO test file successfully."
    else
		print_log "ERROR" "remove IO test file fail."
        return 1
    fi
    #删除日志文件
    rm -f /opt/disk_io_error.txt
    if [ $? -eq 0 ]; then
	    print_log "INFO" "remove IO test log file successfully."
    else
	    print_log "ERROR" "remove IO test log file fail."
        return 1
    fi
    let actual_disk_io_r=`scale=2;echo 2000/${read_time} | bc`
    let actual_disk_io_w=`scale=2;echo 2000/${write_time} | bc`
    #与指定的规格进行比较
    if [[ `echo "${actual_disk_io_r} < ${disk_io}" | bc` -eq 1 ]]; then
	    print_log "ERROR" "The actual disk io_r is $actual_disk_io_r Mb/s, is less than ${disk_io} Mb/s."
        return 2
    fi
    if [[ `echo "${actual_disk_io_w} < ${disk_io}" | bc` -eq 1 ]]; then
	    print_log "ERROR" "The actual disk io_w is $actual_disk_io_w Mb/s, is less than ${disk_io} Mb/s."
        return 3
    fi
	print_log "INFO" "Disk IO check successfully. The actual disk io write rate is ${actual_disk_io_w} Mb/s, is greater than ${disk_io} Mb/s."
	print_log "INFO" "Disk IO check successfully. The actual disk io read rate is ${actual_disk_io_r} Mb/s, is greater than ${disk_io} Mb/s."
    return 0
}