#!/bin/bash
curpath=$(cd `dirname $0`; pwd)
cd $curpath
. ./get_os_info.sh

function createCheckFile
{
    echo "#!/bin/bash
echo  RESULT:$1
    ">/tmp/check_bond_result.sh
    if [[ "$1" == "255" ]]
    then
        echo 'The parameter is invalid. eg: bash config_bond.sh "bond0,10.9.1.20,255.255.255.0,eth0,eth4,10.9.1.1,10.50.0.0,255.255.0.0;bond2,10.9.2.20,255.255.255.0,eth2,eth6,10.9.2.1,10.60.0.0,255.255.0.0"'
        cat >> /tmp/check_bond_result.sh << EOF
    rm -rf /tmp/get_os_info.sh
    rm -rf /tmp/ifcfg-bond-template.sh
    rm -rf /tmp/ifcfg-eth-fctemplate
    rm -rf /tmp/ifcfg-eth-template-euler
    rm -rf /tmp/ifcfg-eth-template
    rm -rf /tmp/ifcfg-bond-template-euler
    rm -rf /tmp/ifcfg-bond-template
    rm -rf /tmp/route-Iface-template
    rm -rf /tmp/config_bond.sh
    chmod 400 /tmp/check_bond.sh
    chmod 400 /tmp/bond_log
    rm -rf /tmp/check_bond_result.sh
EOF
    elif [[ "$1" == "100" ]]
    then
        cat >> /tmp/check_bond_result.sh << EOF
    rm -rf /tmp/get_os_info.sh
    rm -rf /tmp/ifcfg-bond-template.sh
    rm -rf /tmp/ifcfg-eth-fctemplate
    rm -rf /tmp/ifcfg-eth-template-euler
    rm -rf /tmp/ifcfg-eth-template
    rm -rf /tmp/ifcfg-bond-template-euler
    rm -rf /tmp/ifcfg-bond-template
    rm -rf /tmp/route-Iface-template
    rm -rf /tmp/config_bond.sh
    rm -rf /tmp/check_bond.sh
    rm -rf /tmp/bond_log
    rm -rf /tmp/check_bond_result.sh
EOF
    fi
    chmod 750 /tmp/check_bond_result.sh
}


function checkPara()
{
    [[ ${@:$#-1:1} == "-mode" ]] && { mode=${@:$#};shift 2; }
    echo "bond mode is ${mode}" >> /tmp/bond_log
}

function checkMode()
{
    if [ ${mode} -ge 0 ] && [ ${mode} -le 6 ];then
        echo "bond mode is ok"  >> /tmp/bond_log
    else
        echo "bond mode is nok,please check bond mode"  >> /tmp/bond_log
        return 1 
    fi
}

createCheckFile 1
path_prefix=""
path_route_prefix=""
if [ ${linux_type} = "SUSE" ]; then
    path_prefix="/etc/sysconfig/network/ifcfg-"
    path_pre="/etc/sysconfig/network/if"
    path_route_prefix="/etc/sysconfig/network/ifroute-"
    path_route6_prefix="/etc/sysconfig/network/ifroute-"
    
elif [ ${linux_type} = "CentOS" -o ${linux_type} = "Redhat" -o ${linux_type} = "EulerOS" ]; then
    path_prefix="/etc/sysconfig/network-scripts/ifcfg-"
    path_pre="/etc/sysconfig/network-scripts/"
    path_route_prefix="/etc/sysconfig/network-scripts/route-"
    path_route6_prefix="/etc/sysconfig/network-scripts/route6-"
fi


function main
{
    modify_flag="false"
    echo "Configuration" "Configuring netcard ..." > /tmp/bond_log
    
    checkPara $*
    if [ "X${mode}" != "X" ];then
        checkMode ${mode} || return 1
        sed -i "s#mode=[0-6]#mode=$mode#g" ifcfg-bond-template-euler 2>/dev/null
    fi
    type_name=$(echo $1 | awk -F":" '{print $1}')    
    echo "type_nameis : $type_name"
    if [[ "${type_name}X" == "routeX" ]]
    then
        routefile=$(echo $1 | awk -F":" '{print $2}'| awk -F';' '{print $1}')
        if [[ ${routefile} =~ ^bond[0-9]+ || ${routefile} =~ ^eth[0-9]+ ]]
        then
            routeline=$(echo $1 | awk -F":" '{print $2}'| awk -F';' '{for( i=2;i<NF+1; i++ ) print $i}')
            if [[ -z "${routeline}" ]]
            then
                echo 'The parameter is invalid. eg: bash config_bond.sh "route:[bond0/eth0];10.90.127.1,10.90.127.0,255.255.255.0;10.90.128.1,10.90.128.0,255.255.255.0"'
                exit 0
            fi
            read -p "Warning: This operation will overwrite the previous routing configuration, please make sure(y/n)" user_sel
            case ${user_sel} in
            Y|y)
            routefilename="${path_pre}route-${routefile}"
            if [ ${linux_type} = "SUSE" ]
            then
                for route in ${routeline}
                do
                    routerules=($(echo ${route} | awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}'))
                    gateway=${routerules[0]}
                    [[ "${gateway}X" == "X" ]] && echo "The parameter is invalid" && exit 0
                    address=${routerules[1]}
                    [[ "${address}X" == "X" ]] && echo "The parameter is invalid" && exit 0
                    netmask=${routerules[2]}
                    [[ "${netmask}X" == "X" ]] && echo "The parameter is invalid" && exit 0
                    echo "${address} ${gateway} ${netmask} ${routefile}" >> ${routefilename}
			              echo "Configure ${routefilename} successfully."
                done
            else
                index=0
                for route in ${routeline}
                do
                    routerules=($(echo ${route} | awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}'))
                    gateway=${routerules[0]}
                    [[ "${gateway}X" == "X" ]] && echo "The parameter is invalid" && exit 0
                    address=${routerules[1]}
                    [[ "${address}X" == "X" ]] && echo "The parameter is invalid" && exit 0
                    netmask=${routerules[2]}
                    [[ "${netmask}X" == "X" ]] && echo "The parameter is invalid" && exit 0
                    if [[ ${index} = 0 ]]
                    then
                        echo "ADDRESS${index}=${address}" > ${routefilename}
                    else
                        echo "ADDRESS${index}=${address}" >> ${routefilename}
                    fi
                    echo "NETMASK${index}=${netmask}" >> ${routefilename}
                    echo "GATEWAY${index}=${gateway}" >> ${routefilename}
                    let index++
                    echo "Configure ${routefilename} successfully."
                done
            fi
            ;;
            N|n)
                echo "Exit."
                exit 0
            ;;
            *)
                echo "Exit."
                exit 0
            ;;
            esac
        else
            echo 'The parameter is invalid. eg: bash config_bond.sh "route:[bond0/eth0];10.90.127.1,10.90.127.0,255.255.255.0;10.90.128.1,10.90.128.0,255.255.255.0"'
            exit 0
        fi
        exit 0
    fi
    if [[ "${type_name}X" == "deletebondX" ]]
    then
        deletebonds=$(echo $1 | awk -F":" '{print $2}'| awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}')
        if [[ -z "${deletebonds}" ]]
        then
            echo 'The parameter is invalid. eg: bash config_bond.sh "deletebond:bond0,bond1"'
            exit 0
        fi
        read -p "Warning: This operation will delete the bond, please make sure(y/n)" user_sel
        case ${user_sel} in
        Y|y)
            for debond in ${deletebonds}
            do
                cfgfiles=$(grep -r ${debond} ${path_pre} | grep "ifcfg-eth*" | awk -F":" '{print $1}' 2>>/tmp/bond_log)
                for cfg in ${cfgfiles}
                do
                    sed -i "/^NAME.*/d" "${cfg}" 2>/dev/null
                    sed -i "/^MASTER.*/d" "${cfg}" 2>/dev/null
                    sed -i "/^SLAVE.*/d" "${cfg}" 2>/dev/null
                done
                [ -f "${path_prefix}${debond}" ] && rm -f "${path_prefix}${debond}" && echo "Delete ${path_prefix}${debond} successfully."
                [ -f "${path_route_prefix}${debond}" ] && rm -f "${path_route_prefix}${debond}" && echo "Delete ${path_route_prefix}${debond} successfully."
                grep -q "${debond}" /sys/class/net/bonding_masters 2>/dev/null
                [ $? -eq 0 ] && echo -${debond} >/sys/class/net/bonding_masters
            done
        ;;
        N|n)
            echo "Exit."
            exit 0
        ;;
        *)
            echo "Exit."
            exit 0
        ;;
        esac
        exit 0
    fi
    if [[ "${type_name}X" == "deleterouteX" ]]
    then
        deleteroutes=$(echo $1 | awk -F":" '{print $2}'| awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}')
        if [[ -z "${deleteroutes}" ]]
        then
            echo 'The parameter is invalid. eg: bash config_bond.sh "deleteroute:bond0,eth0"'
            exit 0
        fi
        read -p "Warning: This operation will delete the route, please make sure(y/n)" user_sel
        case ${user_sel} in
        Y|y)
            for deroute in ${deleteroutes}
            do
                if [[ ${deroute} =~ ^bond[0-9]+ || ${deroute} =~ ^eth[0-9]+ ]]
                then
                    [ -f "${path_pre}route-${deroute}" ] && rm -f "${path_pre}route-${deroute}" && echo "Delete ${path_pre}route-${deroute} successfully."
                else
                    echo 'The parameter is invalid. eg: bash config_bond.sh "deleteroute:bond0,eth0"'
                    exit 0
                fi
            done
            exit 0
        ;;
        N|n)
            echo "Exit."
            exit 0
        ;;
        *)
            echo "Exit."
            exit 0
        ;;
        esac
    fi
    if [[ "${type_name}X" == "enableX" ]]
    then
        if [ ${linux_type} = "SUSE" ]
        then
            service network restart >> /tmp/bond_log 2>&1
        elif [ ${linux_type} = "CentOS" -o ${linux_type} = "Redhat" -o ${linux_type} = "EulerOS" ]
        then
            systemctl restart network.service >> /tmp/bond_log 2>&1
        fi
        echo "Enable bond successfully."
        exit 0
    fi
    if [[ "${type_name}X" == "cleanX" ]]
    then
        rm -rf /tmp/get_os_info.sh
        rm -rf /tmp/ifcfg-bond-template.sh
        rm -rf /tmp/ifcfg-eth-fctemplate
        rm -rf /tmp/ifcfg-eth-template
        rm -rf /tmp/route-Iface-template
        rm -rf /tmp/config_bond.sh
        echo "Clean tmp successfully"
        exit 0
    fi
    
    confs=(`echo $1 | awk -F';' '{for( i=1;i<NF+1; i++ ) print $i}'`)
    for conf in ${confs[@]}
    do
        ip_addr=
        ipv6_addr=
        prefix=
        netmask=

        values=(`echo $conf | awk -F',' '{for( i=1;i<NF+1; i++ ) print $i}'`)
        bond_name=${values[0]}
        if [[ "${bond_name}X" == "X" ]]
        then
            createCheckFile 255
            exit 0
        elif [[ "${bond_name}" =~ "dual_stack_" ]] 
        then
            bond_name=`echo ${bond_name} | sed 's/dual_stack_//g'`
            dual_stack="dual_stack"
        fi
        if [[ "${values[1]}" =~ ":" ]] #ipv6
        then
            ipv6_addr=${values[1]}
            [ -z "${ipv6_addr}" ] && { createCheckFile 255; exit 0; }
            prefix=${values[2]}
            [ -z "${prefix}" ] && { createCheckFile 255; exit 0; }
            first_netcard=${values[3]}
            [ -z "${first_netcard}" ] && { createCheckFile 255; exit 0; }
            second_netcard=${values[4]}
            [ -z "${second_netcard}" ] && { createCheckFile 255; exit 0; }
            bond_gatewayv6=${values[5]}
            bond_destipv6=${values[6]}
            bond_destprefix=${values[7]}
        else
            ip_addr=${values[1]}
            if [[ "${ip_addr}X" == "X" ]] #ipv4
            then
                createCheckFile 255
                exit 0
            fi
            netmask=${values[2]}
            if [[ "${netmask}X" == "X" ]]
            then
                createCheckFile 255
                exit 0
            fi
            first_netcard=${values[3]}
            if [[ "${first_netcard}X" == "X" ]]
            then
                createCheckFile 255
                exit 0
            fi
            second_netcard=${values[4]}
            if [[ "${second_netcard}X" == "X" ]]
            then
                createCheckFile 255
                exit 0
            fi
            bond_gateway=${values[5]}
            bond_destip=${values[6]}
            bond_destmask=${values[7]}
        fi
        filepath=$path_prefix$bond_name
        cfgfiles=$(grep -r ${bond_name} ${path_pre} | grep "ifcfg-eth*" | awk -F":" '{print $1}' 2>>/tmp/bond_log)
        for cfg in ${cfgfiles}
        do
            sed -i "s#^NAME.*#NAME=#g" ${cfg} 2>/dev/null
            sed -i "s#^MASTER.*#MASTER=#g" ${cfg} 2>/dev/null
            sed -i "s#^SLAVE.*#SLAVE=no#g" ${cfg} 2>/dev/null
        done        
        if [ ${linux_type} = "EulerOS" ]; then
            if [ "${dual_stack}" == "dual_stack" ] && [ -f ${filepath} ]; then
                sed -i "/DEVICE=/d;/BONDING_OPTS=/d;/TYPE=/d;/BONDING_MASTER=/d;/BOOTPROTO=/d;/NAME=/d;/ONBOOT=/d;/NM_CONTROLLED=/d" ${filepath} 
                cat >> ${filepath} << EOF
DEVICE=
BONDING_OPTS='mode=1 miimon=100'
TYPE=Bond
BONDING_MASTER=yes
BOOTPROTO=static
NAME=
ONBOOT=yes
NM_CONTROLLED=no
EOF
            else
                cp -f ifcfg-bond-template-euler $filepath
            fi
            echo "Configuration" "Creating $filepath..." >> /tmp/bond_log
            echo "Configuration" "The ip and netmask is $ip_addr $netmask." >> /tmp/bond_log
            echo "Configuration" "The first netcard bonded is $first_netcard." >> /tmp/bond_log
            cp -f ifcfg-eth-template-euler $path_prefix$first_netcard
            echo "Configuration" "The second netcard bonded is $second_netcard." >> /tmp/bond_log
            cp -f ifcfg-eth-template-euler $path_prefix$second_netcard
            #modify bond template
            sed -i "s#^DEVICE.*#DEVICE='$bond_name'#g" $filepath 2>/dev/null
            sed -i "s#^NAME.*#NAME='$bond_name'#g" $filepath 2>/dev/null
            if [ -n "${ip_addr}" ]
            then
                sed -i "/IPADDR=/d;/NETMASK=/d;" $filepath
                echo "IPADDR='$ip_addr'" >> $filepath 2>/dev/null
                echo "NETMASK='$netmask'" >> $filepath 2>/dev/null
                #modify route-Iface template
                if [[ "${bond_gateway}X" != "X" ]] && [[ "${bond_destip}X" != "X" ]] && [[ "${bond_destmask}X" != "X" ]]
                then
                    echo "Configuration" "The $bond_name static route" >> /tmp/bond_log
                    cp -f route-Iface-template $path_route_prefix$bond_name
                    sed -i "s#^ADDRESS0.*#ADDRESS0='$bond_destip'#g" $path_route_prefix$bond_name 2>/dev/null
                    sed -i "s#^NETMASK0.*#NETMASK0='$bond_destmask'#g" $path_route_prefix$bond_name 2>/dev/null
                    sed -i "s#^GATEWAY0.*#GATEWAY0='$bond_gateway'#g" $path_route_prefix$bond_name 2>/dev/null
                fi
            fi
            if [ -n "${ipv6_addr}" ]
            then
                sed -i "/IPV6ADDR=/d;/IPV6INIT=/d;" $filepath
                echo "IPV6ADDR='$ipv6_addr/$prefix'" >> $filepath 2>/dev/null
                echo "IPV6INIT=yes" >> $filepath 2>/dev/null
                if [[ "${bond_gatewayv6}X" != "X" ]] && [[ "${bond_destipv6}X" != "X" ]] && [[ "${bond_destprefix}X" != "X" ]]
                then
                    echo "Configuration" "The $bond_name static route" >> /tmp/bond_log
                    echo "${bond_destipv6}/${bond_destprefix} via ${bond_gatewayv6} dev ${bond_name}" > $path_route6_prefix$bond_name
                fi
            fi
            #modify first eth template 
            sed -i "s#^NAME.*#NAME='$first_netcard'#g" $path_prefix$first_netcard 2>/dev/null
            sed -i "s#^DEVICE.*#DEVICE='$first_netcard'#g" $path_prefix$first_netcard 2>/dev/null
            sed -i "s#^MASTER.*#MASTER='$bond_name'#g" $path_prefix$first_netcard 2>/dev/null
            #modify second eth template 
            sed -i "s#^NAME.*#NAME='$second_netcard'#g" $path_prefix$second_netcard 2>/dev/null
            sed -i "s#^DEVICE.*#DEVICE='$second_netcard'#g" $path_prefix$second_netcard 2>/dev/null
            sed -i "s#^MASTER.*#MASTER='$bond_name'#g" $path_prefix$second_netcard 2>/dev/null
            echo "Configuration" "Create $filepath successfully." >> /tmp/bond_log
            #delete route-ethX
            rm -rf $path_route_prefix$first_netcard
            rm -rf $path_route_prefix$second_netcard
            rm -rf $path_route6_prefix$first_netcard
            rm -rf $path_route6_prefix$second_netcard
            #set eth configuration to 0
            ifconfig $first_netcard 0
            ifconfig $second_netcard 0
        else
            cp -f ifcfg-bond-template $filepath
            echo "Configuration" "Creating $filepath..." >> /tmp/bond_log
            echo "Configuration" "The ip and netmask is $ip_addr $netmask." >> /tmp/bond_log
            echo "Configuration" "The first netcard bonded is $first_netcard." >> /tmp/bond_log
            cp -f ifcfg-eth-template $path_prefix$first_netcard
            echo "Configuration" "The second netcard bonded is $second_netcard." >> /tmp/bond_log
            cp -f ifcfg-eth-template $path_prefix$second_netcard
            sed -i "s#^IPADDR.*#IPADDR='$ip_addr'#g" $filepath 2>/dev/null
            sed -i "s#^NETMASK.*#NETMASK='$netmask'#g" $filepath 2>/dev/null
            sed -i "s#^BONDING_SLAVE0.*#BONDING_SLAVE0='$first_netcard'#g" $filepath 2>/dev/null
            sed -i "s#^BONDING_SLAVE1.*#BONDING_SLAVE1='$second_netcard'#g" $filepath 2>/dev/null
            echo "Configuration" "Create $filepath successfully." >> /tmp/bond_log
            echo "${bond_destip} ${bond_gateway} ${bond_destmask} ${bond_name}" >> $path_route_prefix$bond_name
            echo "Configuration" "config_bond route successfully." >> /tmp/bond_log
        fi

    done
    echo "Configuration" "Configure netcard end." >> /tmp/bond_log
    if [ ${linux_type} = "SUSE" ]; then
        service network restart >> /tmp/bond_log 2>&1
    elif [ ${linux_type} = "CentOS" -o ${linux_type} = "Redhat" -o ${linux_type} = "EulerOS" ]; then
        systemctl restart network.service >> /tmp/bond_log 2>&1
    fi
    systemctl restart sshd.service >> /tmp/bond_log 2>&1
    createCheckFile 100
}


main $*