#!/bin/bash
#==============================================================
# Copyright  Huawei Technologies Co., Ltd. 1998-2012. All rights reserved.
# File Name             : setLocalTimeZone.sh
# Version:Data          : 
# Description           : set time zone
# Others                : 
# History               : 
#==============================================================


MODULE_NAME="`basename $0 | sed 's/.sh//g'`"
RELATIVE_PATH="`dirname $0`"
    
#get absolute path 
cd "${RELATIVE_PATH}"
ABSOLUATELY_PATH=`pwd`
#import common variable..
. ../common/error_code.inc
. ../common/common.inc
cd - >/dev/null 2>&1

# Name        : fn_write_operation_log
# Description : write operation log
# Parameters  : $1 return value
function fn_write_operation_log()
{
    local RETCODE=$1
    who am i | egrep -w '([0-9]{1,3}\.){3}([0-9]{1,3})' &> /dev/null 
    if [ $? -eq 0 ]
    then
        OPERIP=`who am i | awk '{print $NF}' | sed 's/[()]//g'`
        OPERIP="${OPERIP//:*/}"
    else
        OPERIP=''
    fi

    if [ "${RETCODE}" -eq 0 ]
    then
        echo "`date` `hostname` `whoami` setLocalTimeZone.sh;Successful;Set Timezone Successfully." >> /var/log/localmessages
        echo "Set Timezone Successfully. "
    else
        echo "`date` `hostname` `whoami` setLocalTimeZone.sh;Failed;Set Timezone Failed." >> /var/log/localmessages
        echo "Set Timezone Failed."
    fi    
    chmod 640 /var/log/localmessages

    return 0
}



# Name        : fn_get_config
# Description : get the config from osmu
# Parameters  : $1 the absoluately path of config file 
# Parameter   : $2 the index of host
# Parameter   : $3 get slot number
# Parameter   : $4 get smm card ip
function fn_get_config()
{
    local TMP_CONFIG_FILE=$1 
    local TIME_ZONE

    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.."
    
    TIME_ZONE=`fn_get_value "${TMP_CONFIG_FILE}" "TIME_ZONE"`
    if [ -z "${TIME_ZONE}" ]
    then
        PRINT_LOG "WARN" "The param TIME_ZONE<${TIME_ZONE}> could not be found!" 
        return ${ERROR_PARAM};
    fi 
    
    if [ ! -f "${ZONE_INFO_PATH}/${TIME_ZONE}" ]
    then
        PRINT_LOG "WARN" "The time zone file <${ZONE_INFO_PATH}/${TIME_ZONE}> could not be found!" 
        return ${ERROR_PARAM};
    fi
    
    eval $2="${TIME_ZONE}"
    
    PRINT_LOG "INFO" "Loading <${TMP_CONFIG_FILE}>.. OK!!!"
    return 0;
}


# Name        : fn_set_time_zone
# Description : set TimeZone
# Parameters  : $1 the absoluately path of config file 
# Parameter   : $2 TimeZone

function fn_set_time_zone()
{
    local ZONE_INFO_PATH=$1
    local TIME_ZONE=$2
    
    PRINT_LOG "INFO" "Set time zone "

    timedatectl set-timezone ${TIME_ZONE}
    hwclock -w

    PRINT_LOG "INFO" "Set time zone .. OK!!!"
    return 0;
}

function fn_main() 
{
    local REF_TIME_ZONE
    ZONE_INFO_PATH="/usr/share/zoneinfo"
    ZONE_CFG="/etc/sysconfig/clock"
    PRINT_LOG "INFO" "bash $0 $*"
    if [ $# -lt 1 ]
    then
        PRINT_LOG "WARN" "Usage: $0 <config file>"
        PRINT_LOG "WARN" "e.g:      $0 /opt/osmu/script/properties/sample.properties"
        fn_check_status "${ERROR_PARAM}"
    fi
    
    CONFIG_FILE=`echo "$1" | sed 's/\\\/\//g'`
    
    sed -i "s/[[:space:]]*$//g" "${CONFIG_FILE}"
    fn_check_config_file "${CONFIG_FILE}" || return $?

    fn_title "Setting time zone.."
    fn_get_config "${TMP_CONFIG_FILE}" REF_TIME_ZONE || return $?
    fn_set_time_zone "${ZONE_INFO_PATH}" "${REF_TIME_ZONE}" || return $?

    return 0;
}

#==============================================================
fn_main $@
RET=$?
fn_write_operation_log ${RET}
FUNC_CLEAN_TMP_FILE
exit ${RET}
#==============================================================

