#!/bin/bash

function replace_backuprestore_file()
{
    local path=$1
    local property_file=$2
    if [ -f ${property_file} ];then
        cat ${property_file} | grep "^${path}\$" > /dev/null 2>&1
        if [ $? -eq 0 ];then
            return
        fi
    fi
    echo ${path} >> ${property_file}
}

function insert_backup_file()
{
    mkdir -p /opt/oss/manager/adapter/NCE/backuprestore/
    echo >> /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/backup /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/sudobin /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/tools /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/SEK /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/DmqKafkaService/kafka-logs /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/NMQKafkaService/kafka-logs /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/NMQZookeeperService/ /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/ERService/ /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/BusService/ /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/BackendERService /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/APIMLBService /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/APINotifyProxyService /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/MinAPIGatewayService /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties

    chmod 600 /opt/oss/manager/adapter/NCE/backuprestore/include_list_static_app.properties
    
    replace_backuprestore_file /opt/backup/apps /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/backup/ftpboot /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    echo '/opt/backup/hfs/*'>>/opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    echo '/opt/backup/sopuserboot/*'>>/opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-ACService/**/controller/data/cache/org.eclipse.osgi/ /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-OpenEMService/**/controller/data/cache/org.eclipse.osgi/ /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-OpenEMService/**/controller/ZCN/data/cache/org.eclipse.osgi/ /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-AccessCommonService/*/nemgr/nemgr_access/databasescripts /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-AccessCommonService/*/nemgr/nemgr_access/engineering /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-AccessNeMgrService/*/nemgr/nemgr_access/databasescripts /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-AccessCommonService/*/cbb /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/NMQZookeeperService/data/version-2/acceptedEpoch /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/NMQZookeeperService/data/version-2/currentEpoch /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/U2000AICollectorService/puer_data /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/AnalyzerKafkaService/datalog /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/AnalyzerKafkaService/kafka-logs /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/UtrafficReportService/var /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/InvDCService/export /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/InvDCService/invSync /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/PMEResMgmtService/export /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/InvRawService/export /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/InvRawService/invSync /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/InvColSchdrService/invcolschdrservice-13-0/temp /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/InvColSchdrService/invcolschdrservice-13-0/collectdata /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/PrepareService/invconvert /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/NEResCollectorService/nerescollectorservice-13-0/temp /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/UtrafficReportWebsite/var/puer_data /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/UtrafficReportService/AutoExportReport /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/MessagingBrokeService/* /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/PathCalculatorService/kafka_out /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/ODAEDumpService /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/share/\${PRODUCTNAME}/AccessNeMgrService/oss_tmp/access/pod /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/log/\${PRODUCTNAME}/* /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-ClientPkgMgrService/*/etc/comps/*/client/client/var/log/ /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    replace_backuprestore_file /opt/oss/envs/Product-ClientPkgMgrService/*/etc/comps/*/client/client/*.hprof /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    chmod 600 /opt/oss/manager/adapter/NCE/backuprestore/exclude_list_static_app.properties
    
    chown -R ossadm:ossgroup /opt/oss/manager/adapter
}

#ôڣֻȫΧֲƷͽڵĽűܼ룬ĽűҪĿ¼Ȩİȫ
Main()
{
    #1±ݶļ
    insert_backup_file
}

Main $*
exit 0
