if [[ ! -f /opt/oss/manager/var/agent/managerip.conf ]]; then
    echo exit
    exit 0
fi

managerip=`cat /opt/oss/manager/var/agent/managerip.conf | grep -w managerip | awk -F "=" '{print $2}'`
mgr_ip_0=`echo $managerip | awk -F ',' '{print $1}'`
mgr_ip_1=`echo $managerip | awk -F ',' '{print $2}'`

REPO_TMP_PATH="/opt/oss/manager/var/tmp"

timeout -s KILL 300 ssh ${mgr_ip_0} -o StrictHostKeyChecking=no -n "[ -d ${REPO_TMP_PATH} ] || mkdir -p ${REPO_TMP_PATH}" 2>/dev/null
if [[ "${mgr_ip_1}" != "" ]]; then
    timeout -s KILL 300 ssh ${mgr_ip_1} -o StrictHostKeyChecking=no -n "[ -d ${REPO_TMP_PATH} ] || mkdir -p ${REPO_TMP_PATH}" 2>/dev/null
fi

function handle_weave_hung() 
{
    current_version=`grep APP_VERSION /opt/oss/manager/apps/MCCloudbProxyService/envs/MCCloudbProxyService.properties 2>/dev/null`
    [[ ${current_version} == "" ]] && exit 0
    
    current_version=`echo ${current_version} | awk -F '=' '{print $2}' | awk -F '-' '{print $1}'`
    
    if [[ ${current_version} =~ "22.10." ]] || [[ ${current_version} =~ "22.50." ]] || [[ ${current_version} =~ "23.22." ]]
    then
        modify_record=`grep "start to retry\[isInTransaction=" /opt/oss/manager/apps/Weave/rtsp/CloudbDriverJSRdb/build/lib/connectionimpl.js 2>/dev/null`
        if [[ ${modify_record} == "" ]]
        then
            error_current_version="true"
        fi
    fi
    
    if [[ ${error_current_version} == "true" ]]
    then
        source /opt/oss/manager/bin/engr_profile.sh
        running_tasks=`python -c "from util import httpclient;a=httpclient.IRHttpClient();res=a.get('/rest/plat/omp/v1/main/common/taskmgr/pagingtasks?currentstate=RUNNING');print(res);"`
        if [[ ${running_tasks} =~ "jobID" ]]
        then
            exit 0
        else
            ssh ${mgr_ip_0} -o StrictHostKeyChecking=no -n /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app Weave -tenant manager >/dev/null 2>&1
            if [[ "${mgr_ip_1}" != "" ]]
            then
                ssh ${mgr_ip_1} -o StrictHostKeyChecking=no -n /opt/oss/manager/agent/bin/ipmc_adm -cmd restartapp -app Weave -tenant manager >/dev/null 2>&1
            fi
            sleep 30
        fi
    fi
}
 
handle_weave_hung

exit 0
