#!/bin/bash

grep "RESOURCE_EXHAUSTED: too many waiting requests\|RESOURCE_EXHAUSTED: Bandwidth exhausted" ${LOGPATH}/manager/Weave/weave.log > /dev/null
if [[ "$?" != 0 ]]
then
	echo "no connection pool full problem"
	exit 0
fi

function get_all_ips()
{
    # first use SMPAgentService's python, otherwise use one of rtsp's
    pythonBin="/opt/oss/manager/apps/SMPAgentService/rtsp/python/bin/python"
    if [ ! -f "$pythonBin" ]; then
        pythonBin=$(ls "${INSTALL_ROOT}"/rtsp/python*/bin/python |tail -n 1)
    fi

    cat <<EOF | $pythonBin
#-*-coding:utf-8-*-
import os
import json

try:
    nodelist_file=os.path.join(os.getenv("INSTALL_ROOT", "/opt/oss"), "manager", "etc", "sysconf", "nodelists.json")
    with open(nodelist_file, 'r') as file:
        data=json.loads(file.read())
        for _,node in data['nodeList'].items():
            if 'MGR' in node['role']:
                for ip in node['IPAddresses']:
                        if 'maintenance' in ip['usage']:
                                print(ip['IP'])
                                break
except Exception as e:
    print(e)
finally:
    pass
EOF
}

for nodeip in $(get_all_ips)
do
	echo $nodeip
    ssh $nodeip >/dev/null 2>&1 <<EOF
	${INSTALL_ROOT}/manager/agent/bin/ipmc_adm -cmd restartapp -app MCCloudbProxyService -tenant manager
EOF
done

exit 0