import sys
import time
import json

from getDBConnection import get_zenith_session

from common_tasks.base_task import BaseTask

COMMON_CONFIG = "common_config.json"

class CheckDestinationTables(BaseTask):
    def __init__(self, product_name="NCE"):
        super(CheckDestinationTables, self).__init__()
        self.set_product_name(product_name)
        self.info("CheckDestinationTables init product_name is %s" % product_name)
        self.src_db_session = get_zenith_session('neresdb', 'neresdb', product_name)
        if self.src_db_session is None:
            self.error("neresdb is None")
            return
        self.src_db_session.autocommit(True)
        self.src_db_cursor = self.src_db_session.cursor()
        self.tables = json.load(open(COMMON_CONFIG)).get("table_list", [])


    def check_table(self, table_names):
        self.debug("table_names: %s" % table_names)
        self.info("check_table start")
        for table in self.tables:
            if not table in table_names:
                self.warning("table [%s] not exists" % table)
                return False
        self.info("success.")
        return True

    def check_db_tables(self, retries=3, interval=20):
        self.info("start.")
        sql_stmt = "select table_name from My_tables"
        if self.src_db_session is None:
            return False
        for x in range(retries):
            table_names = list(x[0] for x in self.exec_query_sql(self.src_db_cursor, sql_stmt))
            if self.check_table(table_names):
                self.info("success.")
                return True
            else:
                self.info("wait to retry.")
                time.sleep(interval)

            sys.stdout.flush()
            sys.stderr.flush()
        self.error("failed.")
        return False

    def do(self):
        # 先循环检查待升级的数据库是否已经被创建，30分钟超时
        if not self.check_db_tables():
            self.error("some tables to be upgraded not exist.")
            sys.exit(0)
