#/bin/bash

##################################################
# Name        : exc_migrate_frame.sh
# Description : backup data from database
# param       : $1: "input" $2: Migrate Tools Path
# return      : 0 -- Everything OK; 1 -- Found Error
##################################################

cur_path=$(cd $(dirname $0);pwd)
tool_path=${cur_path}
log_path=${cur_path}/log
if [ ! -d ${log_path} ]
then
    mkdir -p ${log_path}
fi
timeStamp=`date +"%Y%m%d%H%M%S"`
cur_log=${log_path}/exc_migrate_NCE_COPMMON_${timeStamp}.log

echo "$(date +[%H:%M:%S])[INFO] start handle changed data..."
echo "$(date +[%H:%M:%S])[INFO] start handle changed data..." >> ${cur_log}

# 入参校验
function check_param()
{
    local check_tmp=$1
    [ -z "${check_tmp}" ] && return 1
    echo "${check_tmp}" | fgrep -q "../"
    if [ $? -eq 0 ]
    then
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."  >> ${cur_log}
        return 1
    fi
    if [ ! -d "${check_tmp}" ]
    then
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."
        echo "$(date +[%H:%M:%S])[INFO] The input param \"${check_tmp}\" is invalid."  >> ${cur_log}
        return 1
    fi
}

# 获取输入参数
function init_params()
{
    local num=$#
    if [ $((${num}%2)) -eq 1 ]
    then
        num=$((${num}/2+1))
    else
        num=$((${num}/2))
    fi
    local count=1
    for((i=1;i<=${num};i++))
    do
        [[ ${1#-} == "input" ]] && { INPUTPATH=$2;shift 2;check_param "${INPUTPATH}" || return 1; continue; }
    done
}

#
function check_input()
{
    init_params "$@"
    if [ $? -ne 0 ]
    then
        echo "$(date +[%H:%M:%S])[INFO] check_input error,"
        echo "$(date +[%H:%M:%S])[INFO] check_input error," >> ${cur_log}
        return 1
    fi
}

# 获取脚本传入的产品名称
function get_productname()
{
    PRODUCT_NAME=$(cat ${INPUTPATH}/plandata.json 2>/dev/null | python -c "import json; import sys; obj=json.load(sys.stdin); print(obj['productname'])" 2>/dev/null)
    if [ -z "${PRODUCT_NAME}" ]
    then
        echo "$(date +[%H:%M:%S])[INFO] Productname is null."
        echo "$(date +[%H:%M:%S])[INFO] Productname is null." >> ${cur_log}
        return 1
    fi
}

check_input "$@" && get_productname
[ -z "${PRODUCT_NAME}" ] && PRODUCT_NAME="NCE"
echo "$(date +[%H:%M:%S])[INFO] PRODUCT_NAME is ${PRODUCT_NAME}"
echo "$(date +[%H:%M:%S])[INFO] PRODUCT_NAME is ${PRODUCT_NAME}" >> ${cur_log}

status_tncommondb=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'TNCOMMONDB'`
status_ucommondb=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'ucommonDB'`
status_U2000_IS=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'U2000_IS'`
status_InventoryDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'InventoryDB'`
status_MCDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'MCDB'`
status_OldMCDB=`cat /opt/upgrade/backup/migrate/old/containerlist.json |grep -w 'MCDB'`

#migrate MCDB data
if [ "${status_OldMCDB}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found MCDB in NCE Env, start exec data backup by MigrateTool." >> ${cur_log}
    echo "$(date +[%H:%M:%S])[INFO] Begin backup data..."
    echo "$(date +[%H:%M:%S])[INFO] Begin backup data..." >> ${cur_log}
    if [ -f ${tool_path}/execute.sh ];then
        sh ${tool_path}/execute.sh online zenith null ${cur_path}/frameconf 1 1 MCService
        if [ $? -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] Backup data exec execute.sh failed. "
            echo "$(date +[%H:%M:%S])[ERROR] Backup data exec execute.sh failed. " >> ${cur_log}
            exit 1
        fi
    else
        echo "$(date +[%H:%M:%S])[ERROR] No found MigrateTool execute.sh, please check."
        echo "$(date +[%H:%M:%S])[ERROR] No found MigrateTool execute.sh, please check." >> ${cur_log}
        exit 1
    fi
    echo "$(date +[%H:%M:%S])[INFO] End backup data..."
    echo "$(date +[%H:%M:%S])[INFO] End backup data..." >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found MCDB in NCE Env." >> ${cur_log}
fi

#migrate ClockViewDB data
if [ "${status_tncommondb}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found TNCOMMONDB in NCE Env, start exec data backup by MigrateTool." >> ${cur_log}
    echo "$(date +[%H:%M:%S])[INFO] Begin backup data..."
    echo "$(date +[%H:%M:%S])[INFO] Begin backup data..." >> ${cur_log}
    if [ -f ${tool_path}/execute.sh ];then
        sh ${tool_path}/execute.sh online zenith null ${cur_path}/ClockViewConf 1 1 ClockViewService
        if [ $? -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] Backup data exec execute.sh failed. "
            echo "$(date +[%H:%M:%S])[ERROR] Backup data exec execute.sh failed. " >> ${cur_log}
            exit 1
        fi
    else
        echo "$(date +[%H:%M:%S])[ERROR] No found MigrateTool execute.sh, please check."
        echo "$(date +[%H:%M:%S])[ERROR] No found MigrateTool execute.sh, please check." >> ${cur_log}
        exit 1
    fi
    echo "$(date +[%H:%M:%S])[INFO] End backup data..."
    echo "$(date +[%H:%M:%S])[INFO] End backup data..." >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found TNCOMMONDB in NCE Env." >> ${cur_log}
fi

#migrate U2000_IS data
if [ "${status_U2000_IS}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found U2000_IS in NCE Env, start exec data backup by MigrateTool." >> ${cur_log}
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate U2000_IS data..."
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate U2000_IS data..." >> ${cur_log}
    if [ -f ${tool_path}/execute.sh ];then
        sh ${tool_path}/execute.sh online zenith null ${cur_path}/ISServiceConf 1 1 ISService
        if [ $? -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] migrate U2000_IS data exec execute.sh failed. "
            echo "$(date +[%H:%M:%S])[ERROR] migrate U2000_IS data exec execute.sh failed. " >> ${cur_log}
            exit 1
        fi
    else
        echo "$(date +[%H:%M:%S])[ERROR][U2000_IS] No found MigrateTool execute.sh, please check."
        echo "$(date +[%H:%M:%S])[ERROR][U2000_IS] No found MigrateTool execute.sh, please check." >> ${cur_log}
        exit 1
    fi
    echo "$(date +[%H:%M:%S])[INFO] End migrate U2000_IS data..."
    echo "$(date +[%H:%M:%S])[INFO] End migrate U2000_IS data..." >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found U2000_IS in NCE Env." >> ${cur_log}
fi

#migrate Inventory data
if [ "${status_InventoryDB}" ] && [ "${status_OldMCDB}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate Inventory data..."
    echo "$(date +[%H:%M:%S])[INFO] Begin migrate Inventory data..." >> ${cur_log}
    if [ -f ${tool_path}/execute.sh ];then
        sh ${tool_path}/execute.sh online zenith null ${cur_path}/phyInv 1 1 Inventory
        if [ $? -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] migrate Inventory data exec execute.sh failed. "
            echo "$(date +[%H:%M:%S])[ERROR] migrate Inventory data exec execute.sh failed. " >> ${cur_log}
            exit 1
        fi
    else
        echo "$(date +[%H:%M:%S])[ERROR][Inventory] No found MigrateTool execute.sh, please check."
        echo "$(date +[%H:%M:%S])[ERROR][Inventory] No found MigrateTool execute.sh, please check." >> ${cur_log}
        exit 1
    fi
    echo "$(date +[%H:%M:%S])[INFO] End migrate Inventory data..."
    echo "$(date +[%H:%M:%S])[INFO] End migrate Inventory data..." >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found InventoryDB in NCE Env." >> ${cur_log}
fi

# Common interface of exec sql script.
# Will init shscript/app_profile.sh, may be change the temporary environment variables
function execSql()
{
    zenith_user=$1
    sql_file=$2
    product_name=$3
    echo "$(date +[%H:%M:%S])[INFO] start exec sql file ${sql_file}. product_name is ${product_name}.."
    echo "$(date +[%H:%M:%S])[INFO] start exec sql file ${sql_file}. product_name is ${product_name}.." >> ${cur_log}
    if [ -f "${cur_path}/exec_sql.pyc" ]; then
        echo "pyc" >> ${cur_log}
        { echo -e "${zenith_user}\n${sql_file}" ;} | python ${cur_path}/exec_sql.pyc ${cur_path} ${product_name} >> ${cur_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [exec_sql.pyc] failed. error code is: "$ret >> ${cur_log}
            exit $ret
        fi
    else
        echo "py" >> ${cur_log}
        { echo -e "${zenith_user}\n${sql_file}" ;} | python ${cur_path}/exec_sql.py ${cur_path} ${product_name} >> ${cur_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [exec_sql.py] failed. error code is: "$ret >> ${cur_log}
            exit $ret
        fi
    fi
    echo "$(date +[%H:%M:%S])[INFO] End exec sql file ${sql_file}..."
    echo "$(date +[%H:%M:%S])[INFO] End exec sql file ${sql_file}..." >> ${cur_log}
}

if [ -d /opt/oss/manager/apps/MCCommonService/ ]; then
    export APP_ROOT="/opt/oss/manager/apps/MCCommonService/"
else
    export APP_ROOT="/opt/oss/NCE/apps/MCService/"
fi
if [ -f ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh ];then
    . ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh
fi
if [ -f /opt/oss/manager/bin/engr_profile.sh ];then
    source /opt/oss/manager/bin/engr_profile.sh
else
    echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..."
    echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..." >> ${cur_log}
    exit 1
fi

if [ "${status_tncommondb}" ];then
    echo "$(date +[%H:%M:%S])[INFO] bexecSql Found TNCOMMONDB in NCE Env, start exec data backup by MigrateTool." >> ${cur_log}
    execSql "topodb" "topodb.sql" ${PRODUCT_NAME}
else
    echo "$(date +[%H:%M:%S])[INFO] bexecSql No found TNCOMMONDB in NCE Env." >> ${cur_log}
fi

CFG_PATH=${cur_path}/InvPhy_privilege_upgrade_template.json
# phyinv 日志路径指定script下面
backup_log_path=/opt/oss/log/manager/easysuite_upgrade/scriptlog
phyinv_log=${backup_log_path}/phyinv_${timeStamp}.log
if [ "${status_ucommondb}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found ucommonDB in NCE Env ." >> ${phyinv_log}
    if [ -f "${cur_path}/phyinv_web_privilege_upgrade.pyc" ]; then
        echo "pyc" >> ${phyinv_log}
        python ${cur_path}/phyinv_web_privilege_upgrade.pyc ${cur_path} ${CFG_PATH} ${PRODUCT_NAME} >> ${phyinv_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [phyinv_web_privilege_upgrade.pyc] failed. error code is: "$ret >> ${phyinv_log}
            exit $ret
        fi
    else
        echo "py" >> ${phyinv_log}
        python ${cur_path}/phyinv_web_privilege_upgrade.py ${cur_path} ${CFG_PATH} ${PRODUCT_NAME} >> ${phyinv_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [phyinv_web_privilege_upgrade.py] failed. error code is: "$ret >> ${phyinv_log}
            exit $ret
        fi
    fi
else
    echo "$(date +[%H:%M:%S])[INFO] No found ucommonDB in NCE Env." >> ${phyinv_log}
fi


if [ "${status_ucommondb}" ] && [ "${status_OldMCDB}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found ucommonDB in NCE Env ." >> ${phyinv_log}
    if [ -f "${cur_path}/ip_address.pyc" ]; then
        echo "pyc" >> ${phyinv_log}
        python ${cur_path}/ip_address.pyc ${cur_path} ${PRODUCT_NAME} >> ${phyinv_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [ip_address.pyc] failed. error code is: "$ret >> ${phyinv_log}
            exit $ret
        fi
    else
        echo "py" >> ${phyinv_log}
        python ${cur_path}/ip_address.py ${cur_log} ${PRODUCT_NAME} >> ${phyinv_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "execute command [ip_address.py] failed. error code is: "$ret >> ${phyinv_log}
            exit $ret
        fi
    fi
else
    echo "$(date +[%H:%M:%S])[INFO] No found ucommonDB in NCE Env." >> ${phyinv_log}
fi

if [ "${status_U2000_IS}" ];then
    echo "$(date +[%H:%M:%S])[INFO] Found U2000_IS in NCE Env, start exec delete database." >> ${cur_log}
    echo "$(date +[%H:%M:%S])[INFO] Begin delete U2000_IS databse..."
    echo "$(date +[%H:%M:%S])[INFO] Begin delete U2000_IS databse..." >> ${cur_log}
    containerlist_json="/opt/upgrade/backup/migrate/old/containerlist.json"
    # 获取实例名
    if [[ -f "${cur_path}/get_dbInstance.pyc" ]];then
        instance_name=$(python ${cur_path}/get_dbInstance.pyc U2000_IS old ${containerlist_json})
        result=$?
    elif [[ -f "${cur_path}/get_dbInstance.py" ]];then
        instance_name=$(python ${cur_path}/get_dbInstance.py U2000_IS old ${containerlist_json})
        result=$?
    else
        echo "get_dbInstance.py is not exited"
        echo "get_dbInstance.py is not exited" >> ${cur_log}
        exit 1
    fi
    if [[ ${result} -ne 0 ]]
    then
        echo "execute get_dbInstance.py failed"
        echo "execute get_dbInstance.py failed" >> ${cur_log}
        exit 1
    fi

    # 删除U2000_IS数据库
    if [[ -f "${cur_path}/del_database.pyc" ]];then
        python ${cur_path}/del_database.pyc del ${instance_name} U2000_IS ISService post_upgrade ${containerlist_json}
        result_del=$?
    elif [[ -f "${cur_path}/del_database.py" ]];then
        python ${cur_path}/del_database.py del ${instance_name} U2000_IS ISService post_upgrade ${containerlist_json}
        result_del=$?
    else
        echo "del_database.py is not exited"
        echo "del_database.py is not exited" >> ${cur_log}
        exit 1
    fi

    if [[ ${result_del} -ne 0 ]] && [[ ${result_del} -ne 2 ]]
    then
        echo "execute database_command.py failed"
        echo "execute database_command.py failed" >> ${cur_log}
        exit 1
    else
        echo "delete U2000_IS database successfully"
        echo "delete U2000_IS database successfully" >> ${cur_log}
    fi
else
    echo "$(date +[%H:%M:%S])[INFO] No found U2000_IS in NCE Env." >> ${cur_log}
fi

echo "$(date +[%H:%M:%S])[INFO] start exc_common_tasks. PRODUCT_NAME is ${PRODUCT_NAME}" >> ${phyinv_log}
bash ./exc_common_tasks.sh ${PRODUCT_NAME} >> ${cur_log}
if [ $? -ne 0 ];then
    echo "$(date +[%H:%M:%S])[ERROR] exc_common_tasks.sh failed. "
    echo "$(date +[%H:%M:%S])[ERROR] exc_common_tasks.sh failed. " >> ${cur_log}
    exit 1
fi

echo "$(date +[%H:%M:%S])[INFO] End handle changed data..."
echo "$(date +[%H:%M:%S])[INFO] End handle changed data..." >> ${cur_log}

exit 0
