#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys
import json
import codecs
import time

import pyzenith
from util import ossext


def getHostAndPort(db_name, product_name):
    ip = ""
    port = ""
    dic = {}
    file_path = os.path.dirname(__file__)
    migrate_root = os.path.abspath(os.path.dirname(file_path))
    containerList_path = os.path.join('/opt/upgrade/backup/migrate/new', 'containerlist.json').replace('\\', '/')

    with open(containerList_path, 'r') as f:
        dic_json = json.loads(f.read())
        if isinstance(dic_json, dict):  # isinstance:True false
            for servicekey in dic_json:
                dic[servicekey] = dic_json[servicekey]
                if isinstance(dic_json[servicekey], dict):  # dic_json[servicekey]
                    for datekey in dic_json[servicekey]:
                        dic[servicekey][datekey] = dic_json[servicekey][datekey]
                        if isinstance(dic_json[servicekey][datekey], dict):  # dic_json[servicekey][datekey]
                            for dbkey in dic_json[servicekey][datekey]:
                                dic[servicekey][datekey][dbkey] = dic_json[servicekey][datekey][dbkey]
                                if dbkey == db_name and dic[servicekey]["assignedToTenancy"] == product_name:
                                    print("%s get zenith info success,product_name is %s" % (db_name, product_name))
                                    port = dic[servicekey]['port']
                                    ip = dic[servicekey]['ip']
                                    accessReadPort = dic[servicekey]['accessReadPort']
                                    ps = dic[servicekey]['dbUserPasswd']
                                    return ip, port, ps
        print("%s get zenith info failed,product_name is %s" % (db_name, product_name))


def get_zenith_session(user, db_name, product_name="NCE"):
    retry_cnt = 5
    while retry_cnt > 0:
        ip, port, pwd = getHostAndPort(db_name, product_name)
        if ip is None or port is None or pwd is None:
            print("get db_name failed, ip:%s, port:%s" % (ip, port))
            raise Exception("get db_name failed, ip:%s, port:%s" % (ip, port))
        try:
            pwd = ossext.Cipher.decrypt0(pwd)
            conn = pyzenith.connect(ip, user, pwd, str(port))
            if conn is not None:
                return conn
            print("get db conn is None, ip:%s, port:%s" % (ip, port))
        except Exception as e:
            print("get db conn failed, ip:%s, port:%s, exception: %s" % (ip, port, str(e)))
        retry_cnt = retry_cnt - 1
        time.sleep(1)
    raise Exception("get db conn failed!")


if __name__ == '__main__':
    if len(sys.argv) != 3:
        print('usage: get_db.py <user,passwd,dbname>')
        sys.exit(-1)
    get_zenith_session(sys.argv[1], sys.argv[2])
    print("database" + sys.argv[2] + "connect succeed.")
    print(getHostAndPort(sys.argv[2])[1])