# -*- coding: utf-8 -*-
import sys
import os
import time
import uuid

sys.path.append(str(sys.argv[1]))
from getDBConnection import get_zenith_session

PARAM_LIST = [("select * from t_netconf_para", "insert into TBL_NECOMMUPARAM values(:1,:2,:3,:4,:5,:6)", 6),
              ("select * from t_netconf_template", "insert into TBL_NECOMMUPARAMTMPL values(:1,:2,:3,:4,:5)", 5)]

ONE_PACKAGE = 500

class update_necommparam:

    def __init__(self, select_stmt, insert_stmt, column):
        self.idmapping_dic = {}
        self.select_stmt = select_stmt
        self.insert_stmt = insert_stmt
        self.column = column
        self.neresmgmt_sess = get_zenith_session('neresmgmtdb', 'neresmgmtdb')
        if self.neresmgmt_sess is None:
            print("[update_necommparam]neresmgmt_sess is None")
            return
        self.neresmgmt_sess.autocommit(True)
        self.neresmgmt_cursor = self.neresmgmt_sess.cursor()

        self.id_mapping_sess = get_zenith_session('idmappingdb', 'idmappingdb')
        if self.id_mapping_sess is None:
            print("[update_necommparam]get idmappingdb session fail")
            return
        self.id_mapping_sess.autocommit(True)
        self.id_mapping_cursor = self.id_mapping_sess.cursor()
        print ('[update_necommparam]get session success!')

        self.ucommon_sess = get_zenith_session('ucommonDB', 'ucommonDB')
        if self.ucommon_sess is None:
            print("[update_necommparam]ucommon_sess is None")
            return
        self.ucommon_sess.autocommit(True)
        self.ucommon_cursor = self.ucommon_sess.cursor()
        print('[update_necommparam]get ucommon_sess success')

    def allocate_resid(self, paras):
        for para in paras:
            nativeid = "TEMPLATEID=" + para[0]
            self.idmapping_dic[nativeid] = str(uuid.uuid1())

    def get_resid_from_idmapping(self, paras):
        tmp_table_name = "tmp_neid"
        self.id_mapping_cursor.execute('drop table if exists %s' %tmp_table_name)
        self.id_mapping_cursor.execute('create table %s (nativeId varchar(16))' % tmp_table_name)
        insert_stmt = "insert into %s values(:1)" % (tmp_table_name)

        nativeIds = []
        for para in paras:
            data = []
            nativeId = "NE=" + para[0]
            data.append(nativeId)
            tuple_data = tuple(data)
            nativeIds.append(tuple_data)
            if len(nativeIds) == ONE_PACKAGE:
                self.id_mapping_cursor.executemany(insert_stmt, nativeIds)
                print("[get_resid_from_idmapping] one package:%s"%nativeIds)
                nativeIds = []

        if len(nativeIds) != 0:
            self.id_mapping_cursor.executemany(insert_stmt, nativeIds)
            print("[to_update_necommparam] last package datas:%s", nativeIds)

        query_stmt = 'select t_ids.id, t_ids.nativeId from t_ids inner join %s f on t_ids.nativeId= f.nativeId'%tmp_table_name
        print('[get_resid_from_idmapping]query sql: %s'%query_stmt)
        self.id_mapping_cursor.execute(query_stmt)
        result = self.id_mapping_cursor.fetchall()

        for r in result:
            l = list(r)
            self.idmapping_dic[l[1]] = l[0]
            print("[get_resid_from_idmapping] result: %s:%s"%(l[1], l[0]))

        self.id_mapping_cursor.execute('drop table if exists %s' % tmp_table_name)

    def mode_convert(self, mode):
        if mode == 1:
            return "User"
        elif mode == 2:
            return "PrivateKey"
        elif mode == 3:
            return "PrivateKeyPassword"
        else:
            return ""

    def convert_data(self, paras):
        if self.column == 6:
            return self.convert_netconf_para_data(paras)
        else:
            return self.convert_netconf_template_data(paras)

    def convert_netconf_template_data(self, paras):
        '''
        old table:templateID, templateName, userName, password, port, privateKey, passwordPhrase, authMode, loginTimeout, responseTimeout
        new table:TEMPLATEID, TEMPLATENAME, TEMPLATEDESC, TEMPLATETYPE,
        '''
        templateID = paras[0]
        templateName = paras[1]
        userName = paras[2]
        password = paras[3]
        port = paras[4]
        privateKey = paras[5]
        passwordPhrase = paras[6]
        authMode = paras[7]
        loginTimeout = paras[8]
        responseTimeout = paras[9]

        NENATIVEID = "TEMPLATEID=" + templateID
        if self.idmapping_dic.get(NENATIVEID) is None:
            print("[to_update_necommparam] can not find the nativeid in idmapping:%s" % NENATIVEID)
            return []
        TEMPLATEID = self.idmapping_dic.get(NENATIVEID)
        TEMPLATENAME = templateName
        TEMPLATEDESC = ""
        TEMPLATETYPE = "NETCONF"  # 固定
        TEMPLATECONTENT = "{\"authMode\":\"%s\"," \
                            "\"userPrivateKey\":\"%s\"," \
                            "\"port\":%d," \
                            "\"userPrivateKeyPwd\":\"%s\"," \
                            "\"loginTimeout\":%d," \
                            "\"pwd\":\"%s\"," \
                            "\"userName\":\"%s\"," \
                            "\"responseTimeout\":%d}"\
                            %(self.mode_convert(int(authMode)),
                              privateKey,
                              int(port),
                              passwordPhrase,
                              int(loginTimeout),
                              password,
                              userName,
                              int(responseTimeout))

        data = [TEMPLATEID, TEMPLATENAME, TEMPLATEDESC, TEMPLATETYPE, TEMPLATECONTENT]
        return data

    def convert_netconf_para_data(self, paras):
        '''
        old table:devID, devIP, userName, password, port, privateKey, passwordPhrase, authMode, loginTimeout, responseTimeout
        new table:NERESID, NENATIVEID, NEIP, COMMUPARAMTYPE, COMMUPARAMREMARK, COMMUPARAMCONTENT
        '''
        devID = paras[0]
        if not paras[1]:
            print("[convert_netconf_para_data] can not find the devIP in t_netconf_para,devID is :%s" % devID)
            return []
        else:
            devIP = paras[1]
        userName = paras[2]
        password = paras[3]
        port = paras[4]
        privateKey = paras[5]
        passwordPhrase = paras[6]
        authMode = paras[7]
        loginTimeout = paras[8]
        responseTimeout = paras[9]

        NENATIVEID = "NE=" + devID
        if self.idmapping_dic.get(NENATIVEID) is None:
            print("[to_update_necommparam] can not find the nativeid in idmapping:%s" % NENATIVEID)
            return []
        NERESID = self.idmapping_dic.get(NENATIVEID)
        NEIP = devIP
        COMMUPARAMTYPE = "NETCONF"  # 固定
        COMMUPARAMREMARK = "IP"  # 固定区分域
        COMMUPARAMCONTENT = "{\"authMode\":\"%s\"," \
                            "\"userPrivateKey\":\"%s\"," \
                            "\"port\":%d," \
                            "\"userPrivateKeyPwd\":\"%s\"," \
                            "\"loginTimeout\":%d," \
                            "\"pwd\":\"%s\"," \
                            "\"userName\":\"%s\"," \
                            "\"responseTimeout\":%d}"\
                            %(self.mode_convert(int(authMode)),
                              privateKey,
                              int(port),
                              passwordPhrase,
                              int(loginTimeout),
                              password,
                              userName,
                              int(responseTimeout))

        data = [NERESID, NENATIVEID, NEIP, COMMUPARAMTYPE, COMMUPARAMREMARK, COMMUPARAMCONTENT]
        return data

    def to_record(self):
        select_stmt = "select * from T_LOCK_RECORD where LOCK_KEY = 'MIGRATE_SCENE'"
        self.neresmgmt_cursor.execute(select_stmt)
        record_size = self.neresmgmt_cursor.fetchall()
        print("record:%s"%record_size)
        if len(record_size) != 0:
            print("no need to insert")
            return
        curr_time = time.time()
        LOCK_KEY = "MIGRATE_SCENE"
        update_sql = "insert into T_LOCK_RECORD values('%s', %d, %d)"%(LOCK_KEY, 1, int(curr_time))
        print("[to_update_necommparam] record:%s"%update_sql)
        self.neresmgmt_cursor.execute(update_sql)

    def to_update_necommparam(self, netconf_paras):
        list_datas = []
        for paras in netconf_paras:
            data = self.convert_data(paras)
            if len(data) == self.column:
                tuple_data = tuple(data)
                list_datas.append(tuple_data)
            if len(list_datas) == ONE_PACKAGE:
                self.neresmgmt_cursor.executemany(self.insert_stmt, list_datas)
                print("[to_update_necommparam] one package datas:update_necommparam")
                list_datas = []

        if len(list_datas) != 0:
            self.neresmgmt_cursor.executemany(self.insert_stmt, list_datas)
            print("[to_update_necommparam] one package datas:update_necommparam")

        self.to_record()

    def close_session(self):
        self.neresmgmt_cursor.close()
        self.neresmgmt_sess.close()
        self.ucommon_cursor.close()
        self.ucommon_sess.close()
        self.id_mapping_cursor.close()
        self.id_mapping_sess.close()

    def do(self):
        print ('update_necommparam::do start!')
        
        self.ucommon_cursor.execute(self.select_stmt)
        netconf_paras = self.ucommon_cursor.fetchall()
        if netconf_paras:
            netconf_paras = list(netconf_paras)
        print('[do]get netconf_paras data success count:%d'%len(netconf_paras))
        if self.column == 6:
            self.get_resid_from_idmapping(netconf_paras)
        else:
            self.allocate_resid(netconf_paras)
        print('[do]get_resid_from_idmapping done')
        self.to_update_necommparam(netconf_paras)
        print('[do]to_update_necommparam done')
        self.close_session()


if __name__ == '__main__':
    if len(sys.argv) != 2:
        print('usage: python update_necommparam.py ')
        sys.exit(-1)

    print('update_necommparam start>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
    for g_select_stmt, g_insert_stmt, g_column in PARAM_LIST:
        print('select_stmt:%s, insert_stmt:%s, column:%s'%(g_select_stmt, g_insert_stmt, g_column))
        tool = update_necommparam(g_select_stmt, g_insert_stmt, g_column)
        tool.do()
        print(' ')
    print('update_necommparam finished<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
