#!/usr/bin/python
# -*- coding: utf-8 -*-
import sys
import os
import time
import uuid

sys.path.append(str(sys.argv[1]))
from getDBConnection import get_zenith_session

PARAM_LIST = [("select * from tbl_TelnetPara", "insert into TBL_NECOMMUPARAM values(:1,:2,:3,:4,:5,:6)", 6),
              ("select * from tbl_TelnetTemplate", "insert into TBL_NECOMMUPARAMTMPL values(:1,:2,:3,:4,:5)", 5)]

ONE_PACKAGE = 500


class update_necommparam:

    def __init__(self, select_stmt, insert_stmt, column):
        self.idmapping_dic = {}
        self.select_stmt = select_stmt
        self.insert_stmt = insert_stmt
        self.column = column
        self.neresmgmt_sess = get_zenith_session('neresmgmtdb', 'neresmgmtdb')
        if self.neresmgmt_sess is None:
            print("[update_necommparam]neresmgmt_sess is None")
            return
        self.neresmgmt_sess.autocommit(True)
        self.neresmgmt_cursor = self.neresmgmt_sess.cursor()

        self.id_mapping_sess = get_zenith_session('idmappingdb', 'idmappingdb')
        if self.id_mapping_sess is None:
            print("[update_necommparam]get idmappingdb session fail")
            return
        self.id_mapping_sess.autocommit(True)
        self.id_mapping_cursor = self.id_mapping_sess.cursor()
        print ('[update_necommparam]get session success!')

        self.mcdb_sess = get_zenith_session('MCDB', 'MCDB')
        if self.mcdb_sess is None:
            print("[update_necommparam]mcdb_sess is None")
            return
        self.mcdb_sess.autocommit(True)
        self.mcdb_cursor = self.mcdb_sess.cursor()
        print('[update_necommparam]get mcdb_sess success')

    def allocate_resid(self, paras):
        for para in paras:
            nativeid = "TEMPLATEID=" + para[0]
            self.idmapping_dic[nativeid] = str(uuid.uuid1())

    def get_resid_from_idmapping(self, paras):
        tmp_table_name = "tmp_neid"
        self.id_mapping_cursor.execute('drop table if exists %s' %tmp_table_name)
        self.id_mapping_cursor.execute('create table %s (nativeId varchar(16))' % tmp_table_name)
        insert_stmt = "insert into %s values(:1)" % (tmp_table_name)

        nativeIds = []
        for para in paras:
            data = []
            nativeId = "NE=" + para[0]
            data.append(nativeId)
            tuple_data = tuple(data)
            nativeIds.append(tuple_data)
            if len(nativeIds) == ONE_PACKAGE:
                self.id_mapping_cursor.executemany(insert_stmt, nativeIds)
                print("[get_resid_from_idmapping] one package:%s"%nativeIds)
                nativeIds = []

        if len(nativeIds) != 0:
            self.id_mapping_cursor.executemany(insert_stmt, nativeIds)
            print("[to_update_necommparam] last package datas:%s", nativeIds)

        query_stmt = 'select t_ids.id, t_ids.nativeId from t_ids inner join %s f on t_ids.nativeId= f.nativeId'%tmp_table_name
        print('[get_resid_from_idmapping]query sql: %s'%query_stmt)
        self.id_mapping_cursor.execute(query_stmt)
        result = self.id_mapping_cursor.fetchall()

        for r in result:
            l = list(r)
            self.idmapping_dic[l[1]] = l[0]
            print("[get_resid_from_idmapping] result: %s:%s"%(l[1], l[0]))

        self.id_mapping_cursor.execute('drop table if exists %s' % tmp_table_name)

    def protocol_type_convert(self, type):
        if type == 0:
            return "TELNET"
        elif type == 1:
            return "STELNET"
        else:
            return ""

    def privilege_convert(self, state):
        if state == 0:
            return "Disable"
        elif state == 1:
            return "Enable"
        else:
            return ""

    def authmode_convert(self, type, mode):
        telnet_dict = {1:"NOAuth", 2:"User", 3:"Password"}
        stelnet_dict = {1:"User", 2:"PrivateKey", 3:"PrivateKeyPassword"}
        if type == 0:
            return telnet_dict.get(mode, "")
        elif type == 1:
            return stelnet_dict.get(mode, "")
        else:
            return ""

    def convert_data(self, paras):
        if self.column == 6:
            return self.convert_telnet_para_data(paras)
        else:
            return self.convert_telnet_template_data(paras)

    def convert_telnet_template_data(self, paras):
        '''
                old table:TemplateID, TemplateName, AuthMode, LoginUser, LoginPwd, ProtocolVersion, IsEnable, PrivilegeLevel,
                            PrivilegePwd, ResponseTimeout,Port,ProtocolType,ProtocolType,UserPrivateKey,UserPrivateKeyPwd
                new table:TEMPLATEID, TEMPLATENAME, TEMPLATEDESC, TEMPLATETYPE, TEMPLATECONTENT
        '''
        templateID = paras[0]
        templateName = paras[1]
        authMode = paras[2]
        loginUser = paras[3]
        loginPwd = paras[4]
        protocolVersion = paras[5]
        isEnable = paras[6]
        privilegeLevel = paras[7]
        privilegePwd = paras[8]
        loginTimeout = paras[9]
        responseTimeout = paras[10]
        port = paras[11]
        protocolType = paras[12]
        userPrivateKey = paras[13]
        userPrivateKeyPwd = paras[13]

        NENATIVEID = "TEMPLATEID=" + templateID
        if self.idmapping_dic.get(NENATIVEID) is None:
            print("[to_update_necommparam] can not find the nativeid in idmapping:%s" % NENATIVEID)
            return []
        TEMPLATEID = self.idmapping_dic.get(NENATIVEID)
        TEMPLATENAME = templateName
        TEMPLATEDESC = "test"
        TEMPLATETYPE = self.protocol_type_convert(int(protocolType))  # 0：TELNET  1:STELNET  ,\"userPrivateKey\":\"%s\"
        TEMPLATECONTENT = "{\"protocolName\":\"%s\"," \
                            "\"port\":%d," \
                            "\"loginTimeout\":%d," \
                            "\"responseTimeout\":%d," \
                            "\"authMode\":\"%s\"," \
                            "\"userName\":\"%s\"," \
                            "\"pwd\",\"%s\"," \
                            "\"userPrivateKey\":\"%s\"," \
                            "\"userPrivateKeyPwd\":\"%s\"," \
                            "\"privilegeState\":\"%s\"," \
                            "\"privilegeLevel\":%d, " \
                            "\"privilegePwd\":\"%s\"}" \
                            % (TEMPLATETYPE,
                               int(port),
                               int(loginTimeout),
                               int(responseTimeout),
                               self.authmode_convert(int(protocolType), int(authMode)),
                               loginUser,
                               loginPwd,
                               userPrivateKey,
                               userPrivateKeyPwd,
                               self.privilege_convert(int(isEnable)),
                               int(privilegeLevel),
                               privilegePwd)

        data = [TEMPLATEID, TEMPLATENAME, TEMPLATEDESC, TEMPLATETYPE, TEMPLATECONTENT]
        return data

    def convert_telnet_para_data(self, paras):
        '''
        old table:DevID, AuthMode, LoginUser, LoginPwd, ProtocolVersion, IsEnable, PrivilegeLevel, PrivilegePwd, LoginTimeout, ResponseTimeout,Port,ProtocolType,UserPrivateKey,UserPrivateKeyPwd
        new table:NERESID, NENATIVEID, NEIP, COMMUPARAMTYPE, COMMUPARAMREMARK, COMMUPARAMCONTENT
        '''
        devID = paras[0]
        devIP = "test"
        authMode = paras[1]
        loginUser = paras[2]
        loginPwd = paras[3]
        protocolVersion = paras[4]
        isEnable = paras[5]
        privilegeLevel = paras[6]
        privilegePwd = paras[7]
        loginTimeout = paras[8]
        responseTimeout = paras[9]
        port = paras[10]
        protocolType = paras[11]
        userPrivateKey = paras[12]
        userPrivateKeyPwd = paras[13]

        NENATIVEID = "NE=" + devID
        if self.idmapping_dic.get(NENATIVEID) is None:
            print("[to_update_necommparam] can not find the nativeid in idmapping:%s" % NENATIVEID)
            return []
        NERESID = self.idmapping_dic.get(NENATIVEID)
        NEIP = devIP
        COMMUPARAMTYPE = self.protocol_type_convert(int(protocolType))  # 0：TELNET  1:STELNET  ,\"userPrivateKey\":\"%s\"
        COMMUPARAMREMARK = "default"  # 固定区分域
        COMMUPARAMCONTENT = "{\"protocolName\":\"%s\"," \
                            "\"port\":%d," \
                            "\"loginTimeout\":%d," \
                            "\"responseTimeout\":%d," \
                            "\"authMode\":\"%s\"," \
                            "\"userName\":\"%s\"," \
                            "\"pwd\",\"%s\"," \
                            "\"userPrivateKey\":\"%s\"," \
                            "\"userPrivateKeyPwd\":\"%s\"," \
                            "\"privilegeState\":\"%s\"," \
                            "\"privilegeLevel\":%d, " \
                            "\"privilegePwd\":\"%s\"}"\
                            %(COMMUPARAMTYPE,
                              int(port),
                              int(loginTimeout),
                              int(responseTimeout),
                              self.authmode_convert(int(protocolType), int(authMode)),
                              loginUser,
                              loginPwd,
                              userPrivateKey,
                              userPrivateKeyPwd,
                              self.privilege_convert(int(isEnable)),
                              int(privilegeLevel),
                              privilegePwd)

        data = [NERESID, NENATIVEID, NEIP, COMMUPARAMTYPE, COMMUPARAMREMARK, COMMUPARAMCONTENT]
        return data

    def to_record(self):
        select_stmt = "select * from T_LOCK_RECORD where LOCK_KEY = 'MIGRATE_SCENE'"
        self.neresmgmt_cursor.execute(select_stmt)
        record_size = self.neresmgmt_cursor.fetchall()
        print("record:%s"%record_size)
        if len(record_size) != 0:
            print("no need to insert")
            return
        curr_time = time.time()
        LOCK_KEY = "MIGRATE_SCENE"
        update_sql = "insert into T_LOCK_RECORD values('%s', %d, %d)"%(LOCK_KEY, 1, int(curr_time))
        print("[to_update_necommparam] record:%s"%update_sql)
        self.neresmgmt_cursor.execute(update_sql)

    def to_update_necommparam(self, telnet_paras):
        list_datas = []
        for paras in telnet_paras:
            data = self.convert_data(paras)
            if len(data) == self.column:
                tuple_data = tuple(data)
                list_datas.append(tuple_data)
            if len(list_datas) == ONE_PACKAGE:
                self.neresmgmt_cursor.executemany(self.insert_stmt, list_datas)
                print("[to_update_necommparam] last package datas:list_datas")
                list_datas = []

        if len(list_datas) != 0:
            self.neresmgmt_cursor.executemany(self.insert_stmt, list_datas)
            print("[to_update_necommparam] last package datas:list_datas")

        self.to_record()

    def close_session(self):
        self.neresmgmt_cursor.close()
        self.neresmgmt_sess.close()
        self.mcdb_cursor.close()
        self.mcdb_sess.close()
        self.id_mapping_cursor.close()
        self.id_mapping_sess.close()

    def do(self):
        print('update_necommparam::do start!')
        
        self.mcdb_cursor.execute(self.select_stmt)
        telnet_paras = self.mcdb_cursor.fetchall()
        if telnet_paras:
            telnet_paras = list(telnet_paras)
        print('[do]get telnet_paras data success count:%d'%len(telnet_paras))
        if self.column == 6:
            self.get_resid_from_idmapping(telnet_paras)
        else:
            self.allocate_resid(telnet_paras)
        print('[do]get_resid_from_idmapping done')
        self.to_update_necommparam(telnet_paras)
        print('[do]to_update_necommparam done')
        self.close_session()



if __name__ == '__main__':
    if len(sys.argv) != 2:
        print('usage: python update_necommparam.py ')
        sys.exit(-1)

    print('update telenet template to necommparam start>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
    for g_select_stmt, g_insert_stmt, g_column in PARAM_LIST:
        print('select_stmt:%s, insert_stmt:%s, column:%s' % (g_select_stmt, g_insert_stmt, g_column))
        tool = update_necommparam(g_select_stmt, g_insert_stmt, g_column)
        tool.do()
        print(' ')
    print('update telenet template to necommparam finished<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
