from common_tasks import task_logger

class BaseTask:
    def __init__(self):
        self.src_db_cursor = None
        self.dst_db_cursor = None
        self.product_name = "NCE"

    def exec_sql(self, sql, list_datas):
        self.debug("sql: %s" % sql)
        try:
            self.dst_db_cursor.executemany(sql, list_datas)
        except BaseException as be:
            self.warning(be)
            for data in list_datas:
                try:
                    self.dst_db_cursor.executemany(sql, [data])
                except IndexError as ie:
                    self.warning("err is: %s" % ie)
                    self.warning("the sql is: %s" % sql)
                except BaseException as be2:
                    self.warning("err is: %s" % be2)
                    self.warning("the sql is: %s" % sql)

    def exec_query_sql(self, db_cur, select_stmt):
        self.debug("execute sql: %s" % select_stmt)
        try:
            db_cur.execute(select_stmt)
            datas = db_cur.fetchall()
            if datas:
                return list(datas)
            else:
                return []
        except BaseException as be:
            self.warning("execute sql failed, err is: %s" % str(be))

        return []

    def debug(self, msg):
        task_logger.debug(msg)

    def info(self, msg):
        task_logger.info(msg)

    def warning(self, msg):
        task_logger.warning(msg)

    def error(self, msg):
        task_logger.error(msg)

    def set_product_name(self, product_name):
        """
        赋值产品名称
        :param product_name:
        :return:
        """
        self.product_name = product_name
