#/bin/bash

##################################################
# Name        : exc_migrate_frame.sh
# Description : backup data from database
# param       : $1: "input" $2: Migrate Tools Path
# return      : 0 -- Everything OK; 1 -- Found Error
##################################################

cur_path=$(cd $(dirname $0);pwd)

common_log_path=/opt/oss/log/manager/easysuite_upgrade/scriptlog
if [ ! -d ${common_log_path} ]
then
    mkdir -p ${common_log_path}
fi
timeStamp=`date +"%Y%m%d%H%M%S"`
common_log=${common_log_path}/common_${timeStamp}.log
echo "$(date +[%H:%M:%S])[INFO] common_log path is ${common_log}"
echo "$(date +[%H:%M:%S])[INFO] common_log path is ${common_log}" >> ${common_log}

PRODUCT_NAME=$1
[ -z "${PRODUCT_NAME}" ] && PRODUCT_NAME="NCE"
echo "$(date +[%H:%M:%S])[INFO] PRODUCT_NAME is ${PRODUCT_NAME}"
echo "$(date +[%H:%M:%S])[INFO] PRODUCT_NAME is ${PRODUCT_NAME}" >> ${common_log}

# get the product_NCE.json
temp_neres_path=/opt/oss/log/manager/easysuite_upgrade/upgrade_neres/$timeStamp
mkdir -p $temp_neres_path
/opt/oss/manager/tools/resmgr/queryproduct.sh -pn ${PRODUCT_NAME} -output $temp_neres_path
status_FAN=`cat $temp_neres_path/product_${PRODUCT_NAME}.json |grep -w 'NCE-FAN'`
if [ -f /opt/oss/log/fan_upgrade/tmp/scene_data.json ]; then
    status_NOT_PremiumBroadband=`cat /opt/oss/log/fan_upgrade/tmp/scene_data.json |grep install_scene |sed s/[[:space:]]//g |grep -v '"install_scene":"F02' |grep -v '"install_scene":"F04' |grep -v '"install_scene":"F07' |grep -v '"install_scene":"F09'|grep -v '"install_scene":"F16'`
fi
status_IP=`cat $temp_neres_path/product_${PRODUCT_NAME}.json |grep -w 'NCE-IP'`
status_T=`cat $temp_neres_path/product_${PRODUCT_NAME}.json |grep -w 'NCE-T'`
rm -rf $temp_neres_path

if [ -d /opt/oss/manager/apps/MCCommonService/ ]; then
    export APP_ROOT="/opt/oss/manager/apps/MCCommonService/"
else
    export APP_ROOT="/opt/oss/NCE/apps/MCService/"
fi
if [ -f ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh ];then
    . ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh
fi
if [ -f /opt/oss/manager/bin/engr_profile.sh ];then
    source /opt/oss/manager/bin/engr_profile.sh
else
    echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..."
    exit 1
fi

# scene FAN except PremiumBroadband, or scene IP, or scene T
if [ "$status_FAN" -a "$status_NOT_PremiumBroadband" ] || [ "${status_IP}" ] || [ "${status_T}" ]; then
    echo "$(date +[%H:%M:%S])[INFO] Common log path: ${common_log}"
    if [ -f "${cur_path}/common_task_dispatcher.pyc" ]; then
        echo "$(date +[%H:%M:%S])[INFO] pyc" >> ${common_log}
        python ${cur_path}/common_task_dispatcher.pyc ${cur_path} ${PRODUCT_NAME} >> ${common_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] execute command [common_task_dispatcher.pyc] failed. error code is: "$ret >> ${common_log}
            exit $ret
        fi
    else
        echo "$(date +[%H:%M:%S])[INFO] py" >> ${common_log}
        python ${cur_path}/common_task_dispatcher.py ${cur_path} ${PRODUCT_NAME} >> ${common_log}
        ret=$?
        if [ $ret -ne 0 ];then
            echo "$(date +[%H:%M:%S])[ERROR] execute command [common_task_dispatcher.py] failed. error code is: "$ret >> ${common_log}
            exit $ret
        fi
    fi
else
    echo "$(date +[%H:%M:%S])[WARN] common tasks ignored."
    echo "$(date +[%H:%M:%S])[WARN] common tasks ignored." >> ${common_log}
fi

echo "$(date +[%H:%M:%S])[INFO] End handle changed data..."
echo "$(date +[%H:%M:%S])[INFO] End handle changed data..." >> ${common_log}

exit 0
