#!/usr/bin/python
# -*- coding: utf-8 -*-

import os
import sys
import json
import codecs
import pyzenith
from util import ossext

def getHostAndPort(db_name):
    containerList_path = os.path.join('/opt/upgrade/backup/migrate/new', 'containerlist.json').replace('\\', '/')
    
    with open(containerList_path,'r') as f:
        dic_json = json.loads(f.read())
        if isinstance(dic_json, dict) is not True:
            return "", "", ""
    for servicekey in dic_json:
        if isinstance(dic_json[servicekey], dict) is not True:
            continue
        for datekey in dic_json[servicekey]:
            if isinstance(dic_json[servicekey][datekey], dict) is not True:
                continue
            if (db_name in dic_json[servicekey][datekey]):
                port =  dic_json[servicekey]['port']
                ip =  dic_json[servicekey]['ip']
                ps =  dic_json[servicekey]['dbUserPasswd']
                return ip, port, ps
    return "", "", ""

def get_zenith_session(user, db_name):
    accessHost = ""
    accessPort = ""
    dbuserSankrit = ""
    dbuserName = user
    accessHost, accessPort, dbuserSankrit = getHostAndPort(db_name)
    dbuserSankrit = ossext.Cipher.decrypt0(dbuserSankrit)
    conn=pyzenith.connect(accessHost,dbuserName,dbuserSankrit,str(accessPort))
    return conn

if __name__ == '__main__':
    if len(sys.argv) != 3:
        print('usage: get_db.py <user,passwd,dbname>')
        sys.exit(-1)
    get_zenith_session(sys.argv[1],sys.argv[2])
    print("database" + sys.argv[2] + "connect succeed.")
    print(getHostAndPort(sys.argv[2])[1])