#/bin/bash

##################################################
# Name        : exc_migrate_frame.sh
# Description : backup data from database
# param       : $1: "input" $2: Migrate Tools Path
# return      : 0 -- Everything OK; 1 -- Found Error
##################################################

cur_path=$(cd $(dirname $0);pwd)
timeStamp=`date +"%Y%m%d%H%M%S"`
cur_log=${cur_path}/post_upgrade_droptable_${timeStamp}.log

Trace()
{
    echo "[$(date +[%H:%M:%S])] | post_upgrade_droptable | $$ | $1" >> ${cur_log}
}

echo "$(date +[%H:%M:%S])[INFO] start handle changed data..."
Trace "[INFO] start handle changed data..."
# Common interface of exec sql script.
# Will init shscript/app_profile.sh, may be change the temporary environment variables
if [ -d /opt/oss/manager/apps/MCCommonService/ ]; then
    export APP_ROOT="/opt/oss/manager/apps/MCCommonService/"
else
    export APP_ROOT="/opt/oss/NCE/apps/MCService/"
fi
if [ -f ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh ];then
    . ${APP_ROOT}/rtsp/mccommon/tools/shscript/app_profile.sh >> ${cur_log}
fi
if [ -f /opt/oss/manager/bin/engr_profile.sh ];then
    source /opt/oss/manager/bin/engr_profile.sh >> ${cur_log}
else
    echo "$(date +[%H:%M:%S])[INFO] No found engr_profile.sh..."
    Trace "[INFO] No found engr_profile.sh..."
    exit 1
fi

function execSql()
{
    zenith_user=$1
    sql_file=$2
    echo "$(date +[%H:%M:%S])[INFO] start exec sql file ${sql_file}..."
    echo "$(date +[%H:%M:%S])[INFO] start exec sql file ${sql_file}..." >> ${cur_log}
    if [ -f "${cur_path}/exec_sql.pyc" ]; then
        echo "pyc" >> ${cur_log}
        { echo -e "${zenith_user}\n${sql_file}" ;} | python ${cur_path}/exec_sql.pyc ${cur_path} >> ${cur_log}
        ret=$?
        if [ $ret -ne 0 ];then 
            Trace "execute command [exec_sql.pyc] failed once. error code is: $ret"
            sleep 10
            Trace "execute command again. "
            { echo -e "${zenith_user}\n${sql_file}" ;} | python ${cur_path}/exec_sql.pyc ${cur_path} >> ${cur_log}
        fi
    else
        echo "py" >> ${cur_log}
        { echo -e "${zenith_user}\n${sql_file}" ;} | python ${cur_path}/exec_sql.py ${cur_path} >> ${cur_log}
        ret=$?
        if [ $ret -ne 0 ];then 
             Trace "execute command [exec_sql.py] failed once. error code is: $ret"
             sleep 10
             Trace "execute command again. "
             { echo -e "${zenith_user}\n${sql_file}" ;} | python ${cur_path}/exec_sql.py ${cur_path} >> ${cur_log}
        fi
    fi
    echo "$(date +[%H:%M:%S])[INFO] End exec sql file ${sql_file}..."
    Trace "[INFO] End exec sql file ${sql_file}..."
}

##################################################
# У
# @param
#  -input product_NCE.jsonļλ·
##################################################
function check_input()
{
    if [ "${1}" == "-input" -a -n "${2}" ]
    then
        INPUT_PATH=${2}
    else
        Trace "ERROR The input param is invalid."
        exit 1
    fi
}

# check version
check_version()
{
    src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
    Trace "Upgrade src_version:[${src_version}]"

    # only support source version is R19C00 or R20C00
    is_R19C00=`echo ${src_version} | grep V100R019C00`
    is_R20C00=`echo ${src_version} | grep V100R020C00`
    is_R20C10=`echo ${src_version} | grep V100R020C10`
    if [ -z "${is_R19C00}" ] && [ -z "${is_R20C00}" ] && [ -z "${is_R20C10}" ];then
        Trace "No need to deal, src_version:[${src_version}] is not V100R019C00 or V100R020C00 or V100R020C10"
        exit 0
    fi
}

check_input "$@"
check_version
if [ -f "/opt/upgrade/backup/migrate/new/containerlist.json" ]; then
    status_ucommonDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'ucommonDB'`
    status_tncommondb=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'TNCOMMONDB'`
    status_MCDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'MCDB'`
    status_InventoryDB=`cat /opt/upgrade/backup/migrate/new/containerlist.json | grep -w 'InventoryDB'`
    if [ "${status_ucommonDB}" ];then
        Trace "[INFO] Found ucommonDB in NCE Env, start delete invalid table."
        execSql "ucommonDB" "ucommonDB.sql"
    else
        Trace "[INFO] No found ucommonDB in NCE Env."
    fi

    if [ "${status_MCDB}" ];then
        Trace "$(date +[%H:%M:%S])[INFO] Found MCDB in NCE Env, start delete invalid table."
        execSql "MCDB" "MCDB.sql"
    else
        Trace "[INFO] No found MCDB in NCE Env."
    fi

    if [ "${status_InventoryDB}" ];then
        Trace "[INFO] Found InventoryDB in NCE Env, start delete invalid table."
        execSql "InventoryDB" "InventoryDB.sql"
    else
        Trace "[INFO] No found InventoryDB in NCE Env."
    fi
else
    Trace "no found upgrade/backup/migrate/new/containerlist.json, do nothing. exit 0."
    Trace "[INFO] End handle changed data..."
    exit 0
fi

echo "$(date +[%H:%M:%S])[INFO] End handle changed data..."
Trace "[INFO] End handle changed data..."

exit 0
