#!/bin/bash

#---------------------------------------------------------------------------------
#               此脚本不能长期使用，低版本解决证书依赖问题后，需要移除脚本
#---------------------------------------------------------------------------------

# 问题产生背景：
# cll proxy 服务升级残留文件删除，场景：
# V100R021C00SPC202     ->      V100R021C10SPC201B011

# 首先版本共享share目录，路径：/opt/oss/share/NCE/CloudLicenseProxy

# 升级前，启动R21C00，因为共享目录不存在，此时：
#  1、如果证书平台已启动，则生成共享目录，目录下的证书为低版本证书，然后以share目录下的证书启动nginx
#  2、如果证书平台未启动，则以APP_ROOT目录下自带的证书启动nginx

# 升级后，启动R21C10，因为R21C10不依赖证书平台，异步读取证书，最终share目录下的文件肯定是高版本的证书文件

# 回滚后，启动R21C00，此时：
#  1、如果证书平台已启动，则在share下重新生成低版本证书，此时服务能启动
#  2、如果证书平台未启动，则100%启动失败

# 因此，升级回滚场景Proxy服务启动失败，为概率触发的问题（仅发生在R21C10以后的版本回滚到R21C00版本）


# 解决方案：
#  在此脚本中清除共享目录
#    如果证书平台先启动，则重新写入低版本证书，不影响启动
#    如果证书平台后启动，则以APP_ROOT目录下自带的证书启动nginx

SCRIPT_NAME=`basename $0`
LOG_FILE="/tmp/${SCRIPT_NAME}.log"

# 日志记录
function log()
{
    local msg=$1
    echo "[$(date +'%Y-%m-%d %H:%M:%S')] $msg" |tee -a $LOG_FILE
}

# 校验入参
function check_input()
{
    if [ "${1}" == "-input" -a -n "${2}" ]
    then
        INPUT_PATH=${2}
    else
        log "ERROR The input param is invalid."
        exit 0
    fi
}

# 检查版本
check_version_R21C00()
{
    src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
    # 源版本是R21C00才会删共享目录
    is_R21C00=`echo ${src_version} | grep V100R021C00`
    if [ -z "${is_R21C00}" ]; then
        return 1
    fi
    log "src_version:[${src_version}] need remove cloudlicenseproxy share dir"
    return 0
}

# 删除共享目录
remove_share_dir()
{
    # 在OMP节点获取CloudLicenseProxy服务，然后对节点执行命令
    product=`cat ${INPUT_PATH}/plandata.json | grep productname | tr '"' ' ' | awk '{print $3 }'`
    services=$(bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -tenant ${product} -app CloudLicenseProxy -nodeip global | grep "CloudLicenseProxy" | awk -F " " '{print $6}')
    log "node list ${services}"

    for service in ${services}
    do
        log "execute in node: ${service}"
        ssh -tt ossadm@${service} -oStrictHostKeyChecking=no >> ${LOG_FILE} 2>&1 << cmdoff
        sudo -u ossuser rm -rf /opt/oss/share/NCE/CloudLicenseProxy/etc/ssl/solution
        exit
cmdoff
    done
}

# 检查版本
function check_version()
{
    src_version=`cat ${INPUT_PATH}/plandata.json | grep src_version | tr '"' ' ' | awk '{print $3 }'`
    is_R21C00=`echo ${src_version} | grep V100R021C00`
    is_R21C10=`echo ${src_version} | grep V100R021C10`
    if [ -z "${is_R21C00}" ] && [ -z "${is_R21C10}" ]; then
        return 1
    fi
    log "src_version:[${src_version}] need disable cloudlicenseproxy"
    return 0
}

# 在某个节点禁用某个服务
function disable_service()
{
    local target_ip=$1
    log "Start to disable CloudLicenseProxy on ${target_ip}"
    bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd stopapp -tenant ${PRODUCTNAME} -app CloudLicenseProxy" -u ossadm -timeout 3600 -encrypt N | tee -a ${LOG_FILE} 2>&1
    if [ $? -ne 0 ]
    then
        log "Node ${target_ip}:Failed to stopapp CloudLicenseProxy."
        return 1
    fi
    bash ${SSHTOOL} -exectype cmd -ip ${target_ip} -cmd "bash /opt/oss/manager/agent/bin/ipmc_adm -cmd disable -app CloudLicenseProxy" -u ossadm -timeout 3600 -encrypt N | tee -a ${LOG_FILE} 2>&1
    if [ $? -ne 0 ]
    then
        log "Node ${target_ip}:Failed to disable CloudLicenseProxy."
        return 1
    fi
    log "Finished to disable CloudLicenseProxy on ${target_ip}"
}

# 在所有节点禁用某个服务
function disable_all_node_server()
{
    PRODUCTNAME=`cat ${INPUT_PATH}/plandata.json | grep productname | tr '"' ' ' | awk '{print $3 }'`
    SSHTOOL="${OSS_ROOT}/tools/common/sshmgr/sshmgr.sh"
    local nodeips=$(bash /opt/oss/manager/agent/bin/ipmc_adm -cmd statusapp -tenant ${PRODUCTNAME} -app CloudLicenseProxy -nodeip global | grep "CloudLicenseProxy" | awk -F " " '{print $6}')
    for nodeip in ${nodeips}
    do
        disable_service "${nodeip}"
        if [ $? -ne 0 ]
        then
            log "Failed to disable CloudLicenseProxy."
            return 1
        fi
    done
}

# 检查入参
check_input "$@"
check_version_R21C00
verMatch=$?
log "src_version match=${verMatch}"

. /opt/oss/manager/bin/engr_profile.sh
# 版本匹配则执行删除
if [ ${verMatch} == 0 ]
then
    remove_share_dir
fi

check_version
verMatch=$?
log "src_version match=${verMatch}"
# 版本匹配则执行删除
if [ ${verMatch} == 0 ]
then
    disable_all_node_server
fi

# 脚本执行完正常退出，不影响整个回退流程
exit 0