#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/"
LOG_FILE="${LOG_PATH}/getextend_NCE_Common.log"

#####################################
#   初始化日志文件
#####################################
function init_upgrade_log()
{
    if [ ! -d ${LOG_PATH} ]
    then
        mkdir -p ${LOG_PATH}
    fi
    [ -f ${LOG_FILE} ] && rm -f ${LOG_FILE}
}

#####################################
#   查询环境是否为异地HA本地部署
#####################################
function get_extend_info()
{
    local script_name="${SCRIPT_PATH}/getextend_nce_common.py"
    
    . /opt/oss/manager/bin/engr_profile.sh
    
    if [ ! -f "${script_name}" ]
    then
        script_name="${script_name}c"
    fi
    python ${script_name} "$@"
}

function main()
{
    init_upgrade_log
    get_extend_info
}

main $@ >/dev/null 2>&1
exit $?