﻿# coding: utf-8
"""
功 能：db custom sql文件删除处理
版权信息：华为技术有限公司，版本所有(C) 2022-2022
修改记录：2022-03-17 12:00 创建
"""
import logging
import json

from utils.thread_util import MultiThread
from utils.sshUtil import CsshCmd
from utils.log_util import EasysuiteLogger
from taskmgr.status_manager.sub_item_status_mgr import sub_item_decorate
from func.upgrade.common.upgrade_local_ssh import UpgradeLocalSsh

LOCAL_LOGGER = logging.getLogger(__name__)


def _delete_db_script(kvs):
    """
    删除节点initdb_customized.sql
    """
    try:
        logger = EasysuiteLogger.get_logger(kvs, "task_check_db_script_status")
        sub_item_mgr.save_single_sub_item("task_check_db_script_status")
        logger.easysuite_start("begin to delete.")

        ssh_nodes_param = _get_node_connect_info(kvs)
        for site, ssh_node in ssh_nodes_param.items():
            logger.info(f"execute the site {site}, ip {ssh_node.get('login_ip')}.")
            check_results = _exec_cmd(ssh_node, logger)

            # 处理检查结果信息
            if not check_results:
                sub_item_mgr.update_single_sub_item_status(logger, "error")
                return False
            logger.info(f"the site {site}, ip {ssh_node.get('login_ip')} execute success.")
        logger.easysuite_finish("delete custom init sql success.")
        sub_item_mgr.update_single_sub_item_status(logger, "finish")
        return True
    except Exception:
        logger.easysuite_error("Execute delete task exception.")
        sub_item_mgr.update_single_sub_item_status(logger, "error")
        return False


def _exec_cmd(ssh_node, logger):
    """
    执行删除命令
    :param ssh_node:
    :return:
    """
    # 删除当前站点sql文件.
    if UpgradeLocalSsh.is_es_node(ssh_node.get("login_ip")):
        ips = _get_all_node_ips()
        for ip in ips:
            cmd = f"ssh -oStrictHostKeyChecking=no {ip} -n 'sudo -u dbuser bash -c \"test ! -f " \
                  f"/opt/zenith/app/sql/initdb_customized.sql || chmod 700 /opt/zenith/app/sql;rm -fr " \
                  f"/opt/zenith/app/sql/initdb_customized.sql\"'"
            result, out_put = UpgradeLocalSsh.send_custom_local_cmd(cmd, node_ip=ssh_node.get("login_ip"))
            if not result:
                logger.easysuite_error(f"node {ip} execute check scripts failed, result： {result}, output：{out_put}.")
                return False
        logger.info(f"get the ip {ssh_node.get('login_ip')} execute success.")
        return True

    # 对端站点执行删除命令.
    result, out_put = CsshCmd.exec_shell_cmd_su_exec(ssh_node.get("login_ip"), ssh_node.get("login_user"),
                                                     ssh_node.get("login_pawd"), _get_remote_ips_cmd(),
                                                     ssh_node.get("su_user"), ssh_node.get("su_pawd"), proxy_param=None)
    if not result:
        logger.easysuite_error("remote node %s execute check scripts failed." % ssh_node.get("login_ip"))
        return False
    ips = out_put.strip().split(',')

    # 多线程调用命令删除对端站点节点sql文件.
    multi_thread = MultiThread()
    for ip in ips:
        if not ip:
            continue
        multi_thread.add_thread(_execute_remote_product_ip_cmd, ssh_node, ip, logger)
    multi_thread.start()
    multi_thread.join()
    check_results = multi_thread.get()

    # 处理检查结果信息
    if False in check_results:
        return False
    logger.info(f"get the ip {ssh_node.get('login_ip')} execute success.")
    return True


def _execute_remote_product_ip_cmd(ssh_node, ip, logger):
    cmd = f"ssh -oStrictHostKeyChecking=no {ip} -n 'sudo -u dbuser bash -c \"test ! -f " \
          f"/opt/zenith/app/sql/initdb_customized.sql || chmod 700 /opt/zenith/app/sql;rm -fr " \
          f"/opt/zenith/app/sql/initdb_customized.sql\"'"
    result, out_put = CsshCmd.exec_shell_cmd_su_exec(ssh_node.get("login_ip"), ssh_node.get("login_user"),
                                                     ssh_node.get("login_pawd"), cmd, ssh_node.get("su_user"),
                                                     ssh_node.get("su_pawd"), proxy_param=None)
    if not result:
        logger.easysuite_error(f"node {ip} Execute check scripts failed, result： {result}, output：{out_put}.")
        return False
    return True


def _get_all_node_ips():
    node_ips = []
    with open(f'/opt/oss/manager/etc/sysconf/nodelists.json', 'r') as file:
        data = json.load(file)
        for k, v in data.get('nodeList').items():
            for item in v.get('IPAddresses'):
                if 'maintenance' in item.get('usage'):
                    node_ips.append(item.get('IP'))
    return node_ips


def _get_remote_ips_cmd():
    """
    远端站点执行获取节点ip列表的命令
    :return:
    """
    return f'''python -c "
import json
ips = ''
with open('/opt/oss/manager/etc/sysconf/nodelists.json', 'r') as file:
  data = json.load(file)
  for k, v in data.get('nodeList').items():
    for item in v.get('IPAddresses'):
      if 'maintenance' in item.get('usage'):
       ips += item.get('IP') + ',' 
  print(ips)
"'''


def _get_node_connect_info(kvs):
    """
    获取管理节点登录信息
    """
    ssh_node_dict = {}
    login_user = kvs.get("standby_login_user")
    su_user = "ossadm"
    # 非单管场景
    if kvs.get("single_mgr_domain") == "no":
        _get_nms_node_info(kvs, login_user, ssh_node_dict, su_user)
    # 单管场景
    else:
        _get_nce_x_node_info(kvs, login_user, ssh_node_dict, su_user)

    return ssh_node_dict


def _get_nce_x_node_info(kvs, login_user, ssh_node_dict, su_user):
    """
    功能说明:获取非单管场景节点登录信息
    :param kvs:
    :param login_user:
    :param ssh_node_dict:
    :param su_user:
    :return:
    """
    master_node = {
        'login_ip': kvs.get('node_nmsserver_ip'),
        'login_user': login_user,
        'login_pawd': kvs.get('node_nmsserver_%s_pwd' % login_user),
        'su_user': su_user,
        'su_pawd': kvs.get('node_nmsserver_%s_pwd' % su_user),
        'ssh_port': kvs.get('node_nmsserver_ssh_port'),
        'sftp_port': kvs.get('node_nmsserver_sftp_port')
    }
    ssh_node_dict.update({"node": master_node})
    # 异地容灾场景
    if kvs.get("protection") == 'id_protection_hot':
        standby_node = {
            'login_ip': kvs.get('node_standby_nmsserver_ip'),
            'login_user': login_user,
            'login_pawd': kvs.get('node_standby_nmsserver_%s_pwd' % login_user),
            'su_user': su_user,
            'su_pawd': kvs.get('node_standby_nmsserver_%s_pwd' % su_user),
            'ssh_port': kvs.get('node_standby_nmsserver_ssh_port'),
            'sftp_port': kvs.get('node_standby_nmsserver_sftp_port')
        }
        ssh_node_dict.pop("node")
        ssh_node_dict.update({"master": master_node})
        ssh_node_dict.update({"standby": standby_node})


def _get_nms_node_info(kvs, login_user, ssh_node_dict, su_user):
    """
    功能说明:获取单管场景节点登录信息
    :param kvs:
    :param login_user:
    :param ssh_node_dict:
    :param su_user:
    :return:
    """
    master_node = {
        'login_ip': kvs.get('node_omp01_ip'),
        'login_user': login_user,
        'login_pawd': kvs.get('node_omp01_%s_pwd' % login_user),
        'su_user': su_user,
        'su_pawd': kvs.get('node_omp01_%s_pwd' % su_user),
        'ssh_port': kvs.get('node_omp01_ssh_port'),
        'sftp_port': kvs.get('node_omp01_sftp_port')
    }
    ssh_node_dict.update({"node": master_node})
    # 异地容灾场景
    if kvs.get("protection") == 'id_protection_hot':
        standby_node = {
            'login_ip': kvs.get('node_standby_omp01_ip'),
            'login_user': login_user,
            'login_pawd': kvs.get('node_standby_omp01_%s_pwd' % login_user),
            'su_user': su_user,
            'su_pawd': kvs.get('node_standby_omp01_%s_pwd' % su_user),
            'ssh_port': kvs.get('node_standby_omp01_ssh_port'),
            'sftp_port': kvs.get('node_standby_omp01_sftp_port')
        }
        ssh_node_dict.pop("node")
        ssh_node_dict.update({"master": master_node})
        ssh_node_dict.update({"standby": standby_node})


def check(kvs):
    """
    功能描述：判断此任务是否需要执行
    :param kvs: 全局字典
    :return: 检查结果
    """
    return True


global sub_item_mgr


@sub_item_decorate
def exe(kvs):
    ret = list()
    result = _delete_db_script(kvs)
    if result:
        ret.append([('', '', True)])
    else:
        ret.append([('', '', False)])
    return ret
