#!/bin/bash

##################################################
# 获取脚本工作路径和脚本名
##################################################
SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)
OSS_USER=$(id -nu 3001)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/upgrade/easysuite_upgrade/logs"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

##################################################
# 校验执行用户
# 脚本要求使用ossadm用户执行
##################################################
function check_user()
{
    local user
    user=$(whoami)
    if [ "${user}" != "${OSS_USER}" ]
    then
        echo "[$(date +'%Y-%m-%d %H:%M:%S')]| User have no permission to run this script.(easysuite.upgrade.cmd.fail)"
        return 1
    fi
}

# 适配单独升级仲裁场景,获取drservicedb数据
function backup_drservicedb_data()
{
    local arb_config=$1
    if [ ! -d "/opt/oss/manager/apps/DRService" ]
    then
        return 0
    fi

    if [ -f "${SCRIPT_PATH}/../pyscripts/query_database.pyc" ]
    then
        local query_database_file="${SCRIPT_PATH}/../pyscripts/query_database.pyc"
    else
        if [ -f "${SCRIPT_PATH}/../pyscripts/query_database.py" ]
        then
            local query_database_file="${SCRIPT_PATH}/../pyscripts/query_database.py"
        else
            echo "[backup_drservicedb_data] Error: Can not find query_database file." >>${LOG_FILE}
            return 1
        fi
    fi

    local result=$(. /opt/oss/manager/bin/engr_profile.sh; python ${query_database_file} 'get_db_info' 'managedbsvr' 'drservicedb' ${arb_config})
    echo "${result}" | grep "EXEC_SUCCESS" &>/dev/null
    if [ $? -ne 0 -o ! -f "${arb_config}" ]
    then
        echo "[backup_drservicedb_data] Error: ${result}". >>${LOG_FILE}
        echo "[backup_drservicedb_data] Error: Failed to backup drservicedb data." >>${LOG_FILE}
        return 1
    fi
    return 0
}

# 1.失败
# 2.查询所有仲裁信息
#
# AAMonitor
function query_arb()
{
    local arb_config="${ARB_CONFIG}/query_arb.conf"
    if [ "${VERSION}" == "R019C10" -o "${VERSION}" == "R020" ]
    then
        backup_drservicedb_data "${arb_config}" || return 1
    else
        if [ ! -f "${arb_config}" ]
        then
            backup_drservicedb_data "${arb_config}" || return 1
        fi
    fi

    cat "${arb_config}" | grep "^arbiterType " | grep -v "AAMonitor" && return 1
    site_name=$(cat "${arb_config}" | grep "^local_dc " | awk '{print $2}')
    [ -z "${site_name}" ] && return 1

    etcd_ip=$(cat "${arb_config}" | grep "^etcd_servers " | awk '{print $2}')
    if [ ! -f "${SCRIPT_PATH}/../pyscripts/query_arb_ip.py" ]
    then
        site_info=$(. /opt/oss/manager/bin/engr_profile.sh; python ${SCRIPT_PATH}/../pyscripts/query_arb_ip.pyc ${etcd_ip} ${site_name})
    else
        site_info=$(. /opt/oss/manager/bin/engr_profile.sh; python ${SCRIPT_PATH}/../pyscripts/query_arb_ip.py ${etcd_ip} ${site_name})
    fi
    if [ -z "${site_info}" ]
    then
        return 1
    fi
    return 0
}

function main()
{
    check_user >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "easysuite.upgrade.cmd.fail"
        return 1
    fi
    site_info=""
    site_name=""
    etcd_ip=""
    VERSION=$2
    ARB_CONFIG=$4
    if [ ! -d "${ARB_CONFIG}" ]
    then
        mkdir -p ${ARB_CONFIG}
    fi
    query_arb >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        echo "easysuite.upgrade.cmd.fail"
        return 1
    fi
    echo "${site_info}"
}

main "$@"
exit $?
