#!/bin/bash

SCRIPT_PATH=$(cd $(dirname $0);pwd)
SELF_FILE=$(basename $0)

##################################################
# 初始化日志路径和日志文件名
##################################################
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog"
LOG_FILE="${LOG_PATH}/${SELF_FILE//.sh/}.log"

function main()
{
    # 加载公共方法
    . ${SCRIPT_PATH}/common.sh
    LOG "INFO" "Start to init ${LOG_FILE}."
    action="${1}"
    productname="${2}"
    LOG "INFO" "action: ${action}, productname: ${productname}"
    success_flag==/opt/upgrade//success.flag
    echo "1">"${success_flag}"
    id sopuser 2>/dev/null | setfacl -m u:sopuser:r-x /opt/upgrade/success.flag
    . /opt/oss/manager/bin/engr_profile.sh
    if [ "${action}" == "start" ]
    then
        ipmc_adm -cmd startnodes -tenant ${productname} -type app >>${LOG_FILE} 2>&1
        result=$?
    else
        ipmc_adm -cmd stopnodes -tenant ${productname} -type app >>${LOG_FILE} 2>&1
        result=$?
    fi
    LOG "INFO" "result: ${result}"
    if [ ${result} -eq 0 ]
    then
        echo "100">/opt/upgrade/success.flag
    else
        echo "fail">/opt/upgrade/success.flag
    fi
}

main $@ >/dev/null 2>&1 &
exit 0