#!/bin/bash

# ű·
SCRIPT_PATH=$(cd $(dirname $0);pwd)

# ű
SELF_FILE=$(basename $0)

# ű־·
LOG_PATH="/opt/oss/log/manager/easysuite_upgrade/scriptlog/"

#ű־ļ
LOG_FILE="${LOG_PATH}/${SELF_FILE}.log"

# ùĿ¼
WORK_PATH="/opt/upgrade/easysuite_upgrade/workpath/"

# Ʒ plandata.json productnam
PRODUCT_NAME=""

# · plandata.json src_version-des_version
UPGRADE_PATH=""

# WORK_PATH/UPGRADE_PATH/workpath-PRODUCT_NAME/
CONFIG_PATH=""

# INPUTļ·  plandata.json
INPUT_FILE="${2}/plandata.json"

# űʱ·
TMP_PATH="/opt/oss/log/manager/easysuite_upgrade_config/fresh_monitor_full_ability_$(date '+%s')"

##########################################
#  ޸ monitor_full_ability ֶ
##########################################
function modify_monitor_full_ability()
{
    file_path="${1}"
    python <<END
import json
with open('${file_path}', 'r', encoding='utf-8') as r_stream:
    file_data = json.load(r_stream)
with open('${file_path}', 'w', encoding='utf-8') as w_stream:
    file_data.get('productext', {}).update({'monitor_full_ability': '1'})
    json.dump(file_data, w_stream)
END
    return 0
}

##########################################
#  ¹ؼֶ
##########################################
function fresh_monitor_full_ability()
{
    # ʱĿ¼
    mkdir -p ${TMP_PATH}

    # ѯ product_NCE.json
    query_product "${TMP_PATH}" "${PRODUCT_NAME}" || return 1

    # ޸ product_NCE.json
    modify_monitor_full_ability "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1

    #  product_NCE.json
    modify_product "${TMP_PATH}/product_${PRODUCT_NAME}.json" || return 1

    # ˳ʱĿ¼
    rm -rf ${TMP_PATH}
}

##########################################
#  
##########################################
function main()
{
    # عģ
    source $(dirname ${SCRIPT_PATH})/common.sh

    # ִû
    check_ossadm_user || return 1

    # ʼ
    initial_params "${INPUT_FILE}" || return 1

    # ƽ̨
    source /opt/oss/manager/bin/engr_profile.sh

    # ¹ؼֶ
    fresh_monitor_full_ability || return 1

    # Ĭ˳ 0
    return 0
}

main "$@"
exit $?